/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RemoveDestinationCommand
extends AdminCommandBase {
    String _name;
    Boolean _force = new Boolean("false");
    Boolean _removePFile = new Boolean("false");
    static final String COMMANDNAME = "-removeDestination";
    static final String COMMANDMENU = "-removeDestination -name <name> [options]";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeDestination\n   - Delete an existing OC4J JMS destination.\n\nValid switches are: \n   -name <name>                                        - Required  The OC4J JMS provider-specific name of the destination to remove.\n   -force <force>                                      - Optional  Remove regardless of whether messages or consumers exist on the destination. (defaults to false).\n   -removePFile <removePFile>                          - Optional  Remove the persistence file from the filesystem. (defaults to false).\n\n";

    public RemoveDestinationCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("removeDestination subcommand");
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("-name ");
                continue;
            }
            if (command.equalsIgnoreCase("-force")) {
                this._force = new Boolean(this.getNextArgument("-force"));
                continue;
            }
            if (command.equalsIgnoreCase("-removePFile")) {
                this._removePFile = new Boolean(this.getNextArgument("-removePFile"));
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_removeDestination_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._name, "-name");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.removeDestination(this._name, this._force, this._removePFile);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removeDestination_error", new String[]{e.getMessage()}), e);
        }
    }
}

