/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class TestConnectionPoolCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-testDataSourceConnectionPool";
    static final String APPNAME = "-applicationName";
    static final String CONNECTIONPOOLNAME = "-name";
    static final String SQLSTMT = "-sqlStatement";
    static final String USER = "-dbUser";
    static final String PASSWORD = "-dbPassword";
    static final String COMMANDMENU = "-testDataSourceConnectionPool -name <name> -sqlStatement <sqlStatement> ";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -testDataSourceConnectionPool\n   - Test a datasource connection pool connection.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the connection pool.\n   -sqlStatement <sqlStatement>                        - Required  The sql statement to use to test the connection.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n   -dbUser <user>                                      - Optional  The user to use.\n   -dbPassword <password>                              - Optional  The password to use.\n\n";
    String _applicationName;
    String _connectionPoolName;
    String _sqlStatement;
    String _user;
    String _password;

    public TestConnectionPoolCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-testDataSourceConnectionPool subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(CONNECTIONPOOLNAME)) {
                this._connectionPoolName = this.getNextArgument("-name ");
                continue;
            }
            if (command.equalsIgnoreCase(SQLSTMT)) {
                this._sqlStatement = this.getNextArgument("-sqlStatement ");
                continue;
            }
            if (command.equalsIgnoreCase(USER)) {
                this._user = this.getNextArgument("-dbUser ");
                continue;
            }
            if (command.equalsIgnoreCase(PASSWORD)) {
                this._password = this.getNextArgument("-dbPassword ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_testConnectionPool_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._connectionPoolName, CONNECTIONPOOLNAME);
        this.checkArgIsNull(this._sqlStatement, SQLSTMT);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            System.out.println(this._j2eeDeplMgr.testConnectionPool(this._applicationName, this._connectionPoolName, this._sqlStatement, this._user, this._password));
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("testConnectionPool_error", new String[]{e.getMessage()}), e);
        }
    }
}

