/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline.util;

import java.io.PrintStream;

public class CustomizedOutputUtils {
    private static final int JUSTR = 1;
    private static final int JUSTL = 2;
    private static final int JUSTC = 3;
    int index = -1;
    int length;
    int just;
    String label;

    CustomizedOutputUtils(String label, int len, char justChar) {
        this.length = len;
        this.setJust(justChar);
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLen(int len) {
        this.length = len;
    }

    /*
     * WARNING - void declaration
     */
    public int setJust(char justChar) {
        void var2_2;
        int colJust;
        if (justChar == 'L') {
            colJust = 2;
        } else if (justChar == 'R') {
            colJust = 1;
        } else if (justChar == 'C') {
            colJust = 3;
        } else {
            System.err.println("Bad option argument (justification specifier): \"" + justChar + "\"");
            return -1;
        }
        this.just = var2_2;
        return 0;
    }

    public static StringBuffer printCustomizedTable(String msg, PrintStream out) {
        return CustomizedOutputUtils.printCustomizedTable(msg, msg.length(), 2, true, out);
    }

    public static StringBuffer printCustomizedTable(String msg, CustomizedOutputUtils ac, PrintStream out) {
        return CustomizedOutputUtils.printCustomizedTable(msg, ac.length, ac.just, true, out);
    }

    public static StringBuffer printCustomizedTable(String msg, boolean print, PrintStream out) {
        return CustomizedOutputUtils.printCustomizedTable(msg, msg.length(), 2, print, out);
    }

    public static StringBuffer printCustomizedTable(String msg, int fieldw, int jtype, PrintStream out) {
        return CustomizedOutputUtils.printCustomizedTable(msg, fieldw, jtype, true, out);
    }

    public static StringBuffer printCustomizedTable(String msg, int fieldw, int jtype, boolean print, PrintStream out) {
        StringBuffer sb = null;
        int mlen = 0;
        int rspaces = 0;
        int lspaces = 0;
        if (msg == null) {
            msg = "";
        }
        if (fieldw == 0) {
            return new StringBuffer();
        }
        mlen = msg.length();
        if (jtype == 1) {
            rspaces = fieldw - mlen;
        } else if (jtype == 2) {
            lspaces = fieldw - mlen;
        } else {
            rspaces = (fieldw - mlen) / 2;
            lspaces = (int)Math.ceil((double)(fieldw - mlen) / 2.0);
        }
        if (!print) {
            sb = new StringBuffer();
        }
        while (rspaces-- > 0) {
            if (print) {
                out.print(" ");
                continue;
            }
            sb.append(" ");
        }
        if (mlen > fieldw) {
            msg = msg.substring(0, fieldw - 1) + "~";
        }
        if (print) {
            out.print(msg);
        } else {
            sb.append(msg);
        }
        while (lspaces-- > 0) {
            if (print) {
                out.print(" ");
                continue;
            }
            sb.append(" ");
        }
        return sb;
    }
}

