/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.TextDialog;

public class DataElementPane
extends JPanel
implements ActionListener {
    private DataElement[] _elements;
    private JLabel[] _valueLabels;
    private boolean _bold;

    public DataElementPane(DataElement[] elements) {
        this(elements, false, false);
    }

    public DataElementPane(DataElement[] elements, boolean bold) {
        this(elements, bold, false);
    }

    public DataElementPane(DataEntryElement[] elements) {
        this(elements, true, true);
    }

    protected DataElementPane(DataElement[] elements, boolean bold, boolean editable) {
        this._elements = elements;
        this._bold = bold;
        this.setOpaque(false);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(gridbag);
        constraints.fill = 1;
        constraints.ipady = 4;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        Component rigid = Box.createRigidArea(new Dimension(100, 0));
        gridbag.setConstraints(rigid, constraints);
        this.add(rigid);
        this._valueLabels = new JLabel[elements.length];
        for (int e = 0; e < elements.length; ++e) {
            constraints.gridx = 0;
            constraints.gridy = e;
            constraints.gridwidth = 2;
            constraints.weightx = 0.0;
            JLabel nameLabel = this.createNameLabel(elements[e]);
            gridbag.setConstraints(nameLabel, constraints);
            this.add(nameLabel);
            constraints.gridwidth = 1;
            constraints.gridx = 2;
            constraints.weightx = 1.0;
            this._valueLabels[e] = elements[e].getValueLabel();
            this._valueLabels[e].setHorizontalAlignment(2);
            this._valueLabels[e].setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
            this._valueLabels[e].setFont(GuiUtil.getMediumFont());
            this._valueLabels[e].setBackground(Deployer.ValueBackgroundColor);
            this._valueLabels[e].setOpaque(true);
            gridbag.setConstraints(this._valueLabels[e], constraints);
            this.add(this._valueLabels[e]);
            if (!editable) continue;
            constraints.gridx = 3;
            constraints.weightx = 0.0;
            JButton editButton = new JButton("...");
            if (elements[e].isReadOnly()) {
                editButton.setEnabled(false);
            }
            editButton.addActionListener(this);
            Dimension prefSize = nameLabel.getPreferredSize();
            prefSize.width = prefSize.height + 5;
            editButton.setPreferredSize(prefSize);
            editButton.setActionCommand(Integer.toString(e));
            gridbag.setConstraints(editButton, constraints);
            this.add(editButton);
            constraints.gridx = 4;
            constraints.weightx = 0.1;
            JButton docButton = new JButton("Doc");
            docButton.setFont(GuiUtil.getRegularFont());
            docButton.addActionListener(this);
            prefSize.width += 15;
            docButton.setPreferredSize(prefSize);
            docButton.setActionCommand(Integer.toString(e));
            gridbag.setConstraints(docButton, constraints);
            this.add(docButton);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JButton) {
            JButton button = (JButton)obj;
            String text = button.getText();
            if ("...".equals(text)) {
                String actionCommand = e.getActionCommand();
                int index = Integer.valueOf(actionCommand);
                DataEntryElement elem = (DataEntryElement)this._elements[index];
                DataEntryElement[] elements = new DataEntryElement[]{elem};
                String header = "Edit Property";
                DataEntryDialog dialog = DataEntryDialog.createSimpleDataEntryDialog(elements, "Edit Property", null);
                if (!dialog.showDialog()) {
                    return;
                }
            } else if ("Doc".equals(text)) {
                String actionCommand = e.getActionCommand();
                int index = Integer.valueOf(actionCommand);
                DataEntryElement elem = (DataEntryElement)this._elements[index];
                String elemName = elem.getName();
                TextDialog docDialog = new TextDialog(null, elemName + " Documentation", elem.getDoc());
                docDialog.showDialog();
            }
        }
    }

    private JLabel createNameLabel(DataElement element) {
        JLabel label = new JLabel(element.getName());
        label.setBackground(Deployer.TreeBackgroundColor);
        label.setOpaque(true);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
        label.setFont(GuiUtil.getRegularFont());
        if (this._bold) {
            label.setHorizontalAlignment(2);
        } else {
            label.setForeground(Deployer.ValueForegroundColor);
        }
        return label;
    }
}

