/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import oracle.oc4j.admin.deploy.gui.AppInfoManager;
import oracle.oc4j.admin.deploy.gui.ControllerImpl;
import oracle.oc4j.admin.deploy.gui.Deployer;

public class GuiUtil {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private static Font _boldFont;
    private static Font _dialogFont;
    private static Font _dialogInputFont;
    private static Font _boldDialogFont;
    private static Font _regularFont;
    private static Font _mediumFont;

    protected static JFrame getParent() {
        return ControllerImpl.getSingletonController().getParent();
    }

    public static int showYesNoDialog(String title, String message) {
        JOptionPane pane = new JOptionPane(message, 3, 0);
        return GuiUtil.showDialog(pane, title);
    }

    public static int showYesNoCancelDialog(String title, String message) {
        JOptionPane pane = new JOptionPane(message, 3, 1);
        return GuiUtil.showDialog(pane, title);
    }

    public static int messageDialog(String message) {
        JOptionPane pane = new JOptionPane(message);
        return GuiUtil.showDialog(pane, "");
    }

    public static int errDialog(String message) {
        JOptionPane pane = new JOptionPane(message, 0);
        return GuiUtil.showDialog(pane, "Error");
    }

    protected static void setColor(Container container) {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JButton) continue;
            comps[i].setBackground(Deployer.TreeBackgroundColor);
            if (!(comps[i] instanceof Container)) continue;
            GuiUtil.setColor((Container)comps[i]);
        }
    }

    protected static int showDialog(JOptionPane pane, String title) {
        pane.setBackground(Deployer.TreeBackgroundColor);
        GuiUtil.setColor(pane);
        JDialog dlg = pane.createDialog(GuiUtil.getParent(), title);
        dlg.show();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return 2;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return 2;
    }

    public static Font getDialogFont() {
        if (_dialogFont == null) {
            _dialogFont = new Font("Dialog", 0, 12);
        }
        return _dialogFont;
    }

    public static Font getBoldDialogFont() {
        if (_boldDialogFont == null) {
            _boldDialogFont = new Font("Dialog", 1, 12);
        }
        return _boldDialogFont;
    }

    public static Font getDialogInputFont() {
        return GuiUtil.getRegularFont();
    }

    public static Font getRegularFont() {
        if (_regularFont == null) {
            Hashtable<TextAttribute, Float> fontHash = new Hashtable<TextAttribute, Float>();
            fontHash.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            _regularFont = new Font(fontHash);
        }
        return _regularFont;
    }

    public static Font getBoldFont() {
        if (_boldFont == null) {
            Hashtable<TextAttribute, Float> fontHash = new Hashtable<TextAttribute, Float>();
            fontHash.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            _boldFont = new Font(fontHash);
        }
        return _boldFont;
    }

    public static Font getMediumFont() {
        if (_mediumFont == null) {
            Hashtable<TextAttribute, Float> fontHash = new Hashtable<TextAttribute, Float>();
            fontHash.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM);
            _mediumFont = new Font(fontHash);
        }
        return _mediumFont;
    }

    public static JLabel createHeaderLabel(String text) {
        JLabel label = new JLabel(text, 2);
        label.setAlignmentX(0.0f);
        label.setBorder(BorderFactory.createEmptyBorder(3, 0, 7, 0));
        label.setForeground(Deployer.ViewHeaderColor);
        label.setFont(GuiUtil.getRegularFont());
        return label;
    }

    public static Object getMejbReturnObject(Object obj) {
        if (obj.getClass().isArray()) {
            Object[] objs = (Object[])obj;
            obj = objs[0];
        }
        return obj;
    }

    public static File promptUserToSpecifyFile() {
        return GuiUtil.promptUserToSpecifyFile(null, null);
    }

    public static File promptUserToSpecifyFile(String title) {
        return GuiUtil.promptUserToSpecifyFile(title, null);
    }

    public static File promptUserToSpecifyFile(String title, FileFilter filter) {
        int retVal;
        File lastDir;
        JFileChooser chooser = new JFileChooser();
        if (title != null) {
            chooser.setDialogTitle(title);
        }
        if ((lastDir = (File)AppInfoManager.getStoredObject(JFileChooser.class.getName())) != null) {
            chooser.setCurrentDirectory(lastDir);
        }
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        if ((retVal = chooser.showOpenDialog(GuiUtil.getParent())) == 1 || retVal == -1) {
            return null;
        }
        AppInfoManager.storeObject(JFileChooser.class.getName(), chooser.getCurrentDirectory());
        return chooser.getSelectedFile();
    }
}

