/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryPane;
import oracle.oc4j.admin.deploy.gui.ListDataEntryElement;

public class ListDataEntryPane
extends DataEntryPane
implements ActionListener,
ListSelectionListener {
    private final String ADD = "add";
    private final String REMOVE = "remove";
    private ListDataEntryElement _listElement;
    private JList _list;
    private JButton _removeButton;

    public ListDataEntryPane(ListDataEntryElement listElement) {
        super(new DataEntryElement[]{listElement});
        this._listElement = listElement;
        this._list = (JList)this._listElement.getSwingComponent();
        this._list.addListSelectionListener(this);
    }

    protected int getMinWidth() {
        return 190;
    }

    protected int getMinHeight() {
        return 50;
    }

    protected void init() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        JScrollPane scrollPane = new JScrollPane(this.getSwingComponents()[0]);
        this.add((Component)scrollPane, "North");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        String name = this.getDataEntryElements()[0].getName();
        JButton addButton = new JButton("Add " + name);
        addButton.setActionCommand("add");
        addButton.addActionListener(this);
        buttonPane.add(addButton);
        buttonPane.add(Box.createHorizontalStrut(20));
        this._removeButton = new JButton("Remove " + name);
        this._removeButton.setActionCommand("remove");
        this._removeButton.addActionListener(this);
        this._removeButton.setEnabled(((JList)this.getSwingComponents()[0]).getSelectedValue() != null);
        buttonPane.add(this._removeButton);
        buttonPane.add(Box.createHorizontalStrut(20));
        this.add((Component)buttonPane, "South");
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("add")) {
            this._listElement.promptForNewElement();
        } else {
            this._listElement.removeSelectedElement();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this._removeButton.setEnabled(this._list.getSelectedValue() != null);
    }
}

