/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.oc4j.admin.deploy.gui.Deployer;

public class ProgressDialog
extends JDialog
implements Runnable {
    private JProgressBar _progressBar;
    private JButton _cancelButton = new JButton("Cancel");
    protected static final String CANCEL_STRING = "Cancel";

    public ProgressDialog(JFrame parent, String message, String title) {
        this(parent, message, title, null);
    }

    public ProgressDialog(JFrame parent, String message, String title, ActionListener listener) {
        super((Frame)parent, title);
        this.setModal(true);
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Deployer.TreeBackgroundColor);
        content.setLayout(new BoxLayout(content, 1));
        content.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this._progressBar = new JProgressBar();
        this._progressBar.setBackground(Deployer.ValueBackgroundColor);
        this._progressBar.setString(message);
        this._progressBar.setStringPainted(true);
        this._progressBar.setAlignmentX(0.5f);
        this._progressBar.setIndeterminate(true);
        content.add(this._progressBar);
        if (listener != null) {
            JPanel buttonPane = new JPanel();
            buttonPane.setOpaque(false);
            this._cancelButton = new JButton(CANCEL_STRING);
            this._cancelButton.setActionCommand(CANCEL_STRING);
            this._cancelButton.addActionListener(listener);
            buttonPane.add(this._cancelButton);
            content.add(Box.createRigidArea(new Dimension(0, 10)));
            content.add(buttonPane);
        }
        Dimension prefSize = content.getPreferredSize();
        if (prefSize.width < 350) {
            prefSize.width = 350;
        }
        content.setPreferredSize(prefSize);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setIndeterminate(boolean indeterminate) {
        this._progressBar.setIndeterminate(indeterminate);
    }

    public void setMessage(String msg) {
        this._progressBar.setString(msg);
    }

    public void showDialog() {
        new Thread(this).start();
    }

    public void run() {
        this.show();
    }

    public void finished(String message, int pause) {
        this._progressBar.setString(message);
        this._progressBar.setIndeterminate(false);
        try {
            Thread.sleep(pause);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dispose();
    }

    public void setCancelable(boolean canCancel) {
        this._cancelButton.setEnabled(false);
    }
}

