/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ResourceRootNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.gui.WebSiteRootNode;

public class ResourceJTree
extends ViewableJTree
implements ActionListener {
    protected JPopupMenu _clusterNodePopup;
    protected static final String SELECT_TARGET_MENU_STRING = "Select Target for Deployment";
    protected static final String DESELECT_TARGET_MENU_STRING = "Deselect Target";
    protected static final String START_MENU_STRING = "Start";
    protected static final String STOP_MENU_STRING = "Stop";
    protected JMenuItem _selectClusterMenuItem;
    protected JMenuItem _deselectClusterMenuItem;
    protected JMenuItem _startMenuItem;
    protected JMenuItem _stopMenuItem;

    private ResourceJTree(ViewableJTreeNode rootNode) {
        super(rootNode, false);
    }

    public static ResourceJTree createResourceJTree(DeploymentManager manager, Target target) {
        ResourceJTree jtree = new ResourceJTree(new ResourceRootNode(target, manager));
        return jtree;
    }

    private void createClusterNodePopupMenu() {
        this._clusterNodePopup = new JPopupMenu();
        this._selectClusterMenuItem = new JMenuItem(SELECT_TARGET_MENU_STRING);
        this._deselectClusterMenuItem = new JMenuItem(DESELECT_TARGET_MENU_STRING);
        this._selectClusterMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._deselectClusterMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._selectClusterMenuItem.setFont(GuiUtil.getRegularFont());
        this._deselectClusterMenuItem.setFont(GuiUtil.getRegularFont());
        this._selectClusterMenuItem.addActionListener(this);
        this._deselectClusterMenuItem.addActionListener(this);
        this._deselectClusterMenuItem.setEnabled(false);
        this._clusterNodePopup.add(this._selectClusterMenuItem);
        this._clusterNodePopup.add(this._deselectClusterMenuItem);
    }

    public JPopupMenu getPopupForNode(ViewableJTreeNode node) {
        return null;
    }

    public WebSiteRootNode getWebRoot() {
        ResourceRootNode rootNode = (ResourceRootNode)this.getRootNode();
        return rootNode.getWebRoot();
    }

    public String[] getWebSiteNames() {
        ResourceRootNode rootNode = (ResourceRootNode)this.getRootNode();
        WebSiteRootNode webRoot = rootNode.getWebRoot();
        if (webRoot.getNumJTreeChildren() == 0) {
            return null;
        }
        String[] names = new String[webRoot.getNumJTreeChildren()];
        int i = 0;
        Enumeration e = webRoot.children();
        while (e.hasMoreElements()) {
            names[i++] = (String)e.nextElement();
        }
        return names;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = this.getLastSelectedPathComponent();
    }

    public String getTreeHeader() {
        return "Global Resources for " + this.getName();
    }

    public String getTreeName() {
        return "Resources";
    }
}

