/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.DeployTargetNode;
import oracle.oc4j.admin.deploy.gui.Deployer;

public class TargetsDialog
extends JDialog
implements ActionListener {
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    protected JComboBox _targetsList;
    protected boolean _response;
    protected DeployTargetNode _selectedTarget;

    public TargetsDialog(JFrame parent, DeployTargetNode[] targets) {
        super((Frame)parent, "Targets");
        String labelString = "Choose deployment target";
        this.setModal(true);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Deployer.TreeBackgroundColor);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 15, 15, 15));
        JLabel titleLabel = new JLabel(labelString, 0);
        titleLabel.setAlignmentX(0.5f);
        contentPane.add(titleLabel);
        contentPane.add(Box.createVerticalStrut(10));
        this._targetsList = new JComboBox<DeployTargetNode>(targets);
        this._targetsList.setBackground(Color.white);
        contentPane.add(this._targetsList);
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton okButton = new JButton(OK_STRING);
        okButton.setActionCommand(OK_STRING);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(CANCEL_STRING);
        cancelButton.setActionCommand(CANCEL_STRING);
        cancelButton.addActionListener(this);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        contentPane.add(Box.createVerticalStrut(10));
        contentPane.add(buttonPane);
        Dimension prefSize = contentPane.getPreferredSize();
        prefSize.width = 275;
        contentPane.setPreferredSize(prefSize);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean showDialog() {
        this.show();
        return this._response;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(CANCEL_STRING)) {
            this._response = false;
            this.dispose();
        } else {
            this._selectedTarget = (DeployTargetNode)this._targetsList.getSelectedItem();
            this._response = true;
            this.dispose();
        }
    }

    protected DeployTargetNode getTarget() {
        return this._selectedTarget;
    }
}

