/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;

public class ViewableJTree
extends JTree {
    protected ViewableJTreeNode _rootNode;
    protected ViewableJTreeNode _semiSelectedNode;
    protected BeanRootNode _realRootNode;
    protected PopupListener _popupListener = new PopupListener();

    public ViewableJTree(ViewableJTreeNode rootNode) {
        this(rootNode, true);
    }

    public ViewableJTree(BeanRootNode rootNode) {
        this(rootNode.getFirstChild(), true);
        this._realRootNode = rootNode;
    }

    public ViewableJTree(ViewableJTreeNode rootNode, boolean showRoot) {
        super(rootNode);
        this._rootNode = rootNode;
        this.setCellRenderer(new IconNodeRenderer());
        this.setSelectionModel(new MyTreeSelectionModel());
        this.setShowsRootHandles(true);
        this.setRootVisible(showRoot);
        this.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this._popupListener);
    }

    public ViewableJTreeNode getRootNode() {
        return this._rootNode;
    }

    protected BeanRootNode getRealRootNode() {
        return this._realRootNode;
    }

    public String getTreeHeader() {
        return null;
    }

    public String getTreeName() {
        return null;
    }

    public String getTreeDescription() {
        return null;
    }

    public JPopupMenu getPopupForNode(ViewableJTreeNode node) {
        return null;
    }

    public void clearSemiSelection() {
        if (this._semiSelectedNode != null) {
            this._semiSelectedNode.setSemiSelected(false);
            ((DefaultTreeModel)this.getModel()).nodeChanged(this._semiSelectedNode);
            this._semiSelectedNode = null;
        }
    }

    public void clearSelection(boolean leaveHilighted) {
        if (leaveHilighted) {
            ViewableJTreeNode node;
            this._semiSelectedNode = node = (ViewableJTreeNode)this.getLastSelectedPathComponent();
            if (node != null) {
                node.setSemiSelected(true);
            }
        }
        this.clearSelection();
    }

    class MyTreeSelectionModel
    extends DefaultTreeSelectionModel {
        public void setSelectionPaths(TreePath[] paths) {
            if (paths != null && paths.length > 0) {
                ViewableJTree.this.clearSemiSelection();
            }
            super.setSelectionPaths(paths);
        }
    }

    class IconNodeRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            URL url;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ViewableJTreeNode node = (ViewableJTreeNode)value;
            String iconName = node.jtreeIconName();
            if (iconName != null && (url = ClassLoader.getSystemResource("images/" + iconName + ".jpg")) != null) {
                this.setIcon(new ImageIcon(url));
            }
            this.setToolTipText(node.jtreeToolTip());
            if (sel) {
                this.setOpaque(false);
            } else {
                if (node.isSemiSelected()) {
                    this.setBackground(new Color(205, 205, 205));
                } else {
                    this.setBackground(Deployer.TreeBackgroundColor);
                }
                this.setOpaque(true);
            }
            return this;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ViewableJTree tree = (ViewableJTree)e.getComponent();
                TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
                if (treePath == null) {
                    return;
                }
                ViewableJTreeNode node = (ViewableJTreeNode)treePath.getLastPathComponent();
                JPopupMenu menu = tree.getPopupForNode(node);
                if (menu != null) {
                    tree.setSelectionPath(treePath);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

