/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.Manifest;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.jmx.shared.util.JarTool;
import oracle.xml.parser.v2.XMLDocument;

public abstract class J2eeFile
implements DeployableObject {
    public static final String EAR_STD_XML_ENTRY = "META-INF/application.xml";
    public static final String EAR_DEP_XML_ENTRY = "META-INF/orion-application.xml";
    public static final String EJB_STD_XML_ENTRY = "META-INF/ejb-jar.xml";
    public static final String EJB_DEP_XML_ENTRY = "META-INF/orion-ejb-jar.xml";
    public static final String WAR_STD_XML_ENTRY = "WEB-INF/web.xml";
    public static final String WAR_DEP_XML_ENTRY = "WEB-INF/orion-web.xml";
    public static final String CAR_STD_XML_ENTRY = "META-INF/application-client.xml";
    public static final String CAR_DEP_XML_ENTRY = "META-INF/orion-application-client.xml";
    public static final String RAR_STD_XML_ENTRY = "META-INF/ra.xml";
    public static final String RAR_DEP_XML_ENTRY = "META-INF/oc4j-ra.xml";
    public static final String WS_STD_XML_ENTRY = "META-INF/webservices.xml";
    public static final String WEB_WS_STD_XML_ENTRY = "WEB-INF/webservices.xml";
    public static final String WS_DEP_XML_ENTRY = "META-INF/oracle-webservices.xml";
    public static final String WEB_WS_DEP_XML_ENTRY = "WEB-INF/oracle-webservices.xml";
    public static final String EAR_JAZN_DATA_ENTRY = "META-INF/jazn-data.xml";
    public static final String MANIFEST_ENTRY = "META-INF/manifest";
    protected JarTool _jarTool = null;
    protected File _file = null;
    protected String _entryName = null;
    protected J2eeFile _parent = null;
    private BeanRootNode _stdXml;
    private BeanRootNode _wsStdXml;
    private boolean _dtdValidation;
    private boolean _noConfiguration = false;
    protected boolean _tmpFile = false;

    public J2eeFile(File j2eeFile) throws ExtendedRuntimeException {
        this(j2eeFile, null, null, false);
    }

    public J2eeFile(File j2eeFile, boolean dtdValidation) throws ExtendedRuntimeException {
        this(j2eeFile, null, null, dtdValidation);
    }

    public J2eeFile(File j2eeFile, String entryName, J2eeFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        try {
            if (j2eeFile != null) {
                this._jarTool = new JarTool(j2eeFile);
            }
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("fileNotAccessible", new String[]{j2eeFile.getAbsolutePath()}), e);
        }
        this._file = j2eeFile;
        this._entryName = entryName;
        this._parent = parent;
        this._stdXml = null;
        this._wsStdXml = null;
        this._dtdValidation = dtdValidation;
    }

    public boolean getDtdValidationMode() {
        return this._dtdValidation;
    }

    public Enumeration entries() {
        return this._jarTool.entries();
    }

    public File getEntryAsFile(String entryName) throws ExtendedRuntimeException {
        File entryFile = null;
        try {
            if (this._jarTool == null) {
                this._file = this._parent.getEntryAsFile(this._entryName);
                this._jarTool = new JarTool(this._file);
            }
            entryFile = this._jarTool.extractFile(entryName);
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("entryNotFound", new String[]{entryName, this._file.getAbsolutePath()}), e);
        }
        return entryFile;
    }

    public InputStream getEntry(String entryName) throws ExtendedRuntimeException {
        InputStream entryStream = null;
        try {
            entryStream = this._jarTool != null ? this._jarTool.readEntry(entryName) : this._parent._jarTool.readEntry(this._entryName, entryName);
        }
        catch (ExtendedRuntimeException e) {
            String source = this._jarTool != null ? this._file.getAbsolutePath() : this._entryName;
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("entryNotFound", new String[]{entryName, source}), e);
        }
        return entryStream;
    }

    public InputStream getEntry(String uri, String entryName) throws ExtendedRuntimeException {
        InputStream entryStream = null;
        try {
            entryStream = this._parent._jarTool.readEntry(uri, entryName);
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("entryNotFound", new String[]{entryName, this._entryName}), e);
        }
        return entryStream;
    }

    public void updateEntry(String entryName, File file) throws ExtendedRuntimeException {
        try {
            if (this._jarTool == null) {
                this._file = this._parent.getEntryAsFile(this._entryName);
                this._jarTool = new JarTool(this._file);
            }
            this._jarTool.updateEntry(entryName, file);
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("entryUpdateError", new String[]{entryName, this._file.getAbsolutePath()}), e);
        }
    }

    public void addEntry(String entryName, File file) throws ExtendedRuntimeException {
        try {
            if (this._jarTool == null) {
                this._file = this._parent.getEntryAsFile(this._entryName);
                this._jarTool = new JarTool(this._file);
            }
            this._jarTool.addEntry(entryName, file);
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("entryAddError", new String[]{entryName, file.getAbsolutePath()}), e);
        }
    }

    public void includeEntry(String entryName, File file) throws ExtendedRuntimeException {
        if (this._jarTool == null) {
            this._file = this._parent.getEntryAsFile(this._entryName);
            this._jarTool = new JarTool(this._file);
        }
        if (this._jarTool.hasEntry(entryName)) {
            this._jarTool.updateEntry(entryName, file);
        } else {
            this._jarTool.addEntry(entryName, file);
        }
    }

    public void removeEntry(String entryName) throws ExtendedRuntimeException {
        try {
            if (this._jarTool == null) {
                this._file = this._parent.getEntryAsFile(this._entryName);
                this._jarTool = new JarTool(this._file);
            }
            this._jarTool.removeEntry(entryName);
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("entryRemoveError", new String[]{entryName}), e);
        }
    }

    public Manifest getManifest() throws ExtendedRuntimeException {
        try {
            if (this._jarTool == null) {
                this._file = this._parent.getEntryAsFile(this._entryName);
                this._jarTool = new JarTool(this._file);
            }
            return this._jarTool.getManifest();
        }
        catch (ExtendedRuntimeException e) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("noManifest", new String[]{this._file.getAbsolutePath()}), e);
        }
    }

    public boolean hasEntry(String entryName) {
        if (this._jarTool == null) {
            this._file = this._parent.getEntryAsFile(this._entryName);
            this._jarTool = new JarTool(this._file);
        }
        return this._jarTool.hasEntry(entryName);
    }

    public BeanRootNode getStdXml() {
        return this._stdXml;
    }

    public void setStdXml(BeanRootNode stdXml) throws ExtendedRuntimeException {
        if (!this.checkStdXml(stdXml)) {
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("wrongArgumentType", new String[]{"J2eeFile.setStdXml()"}));
        }
        this._stdXml = stdXml;
    }

    public BeanRootNode getWSStdXml() {
        return this._wsStdXml;
    }

    public void setWSStdXml(BeanRootNode wsStdXml) throws ExtendedRuntimeException {
        this._wsStdXml = wsStdXml;
    }

    public void noConfiguration(boolean noConfig) {
        this._noConfiguration = noConfig;
    }

    public boolean noConfiguration() {
        return this._noConfiguration;
    }

    public void close() {
        if (this._jarTool != null) {
            this._jarTool.close();
            this._jarTool = null;
        }
        if (this._tmpFile) {
            this._file.delete();
        }
        this._file = null;
        this._parent = null;
        this._stdXml = null;
        this._wsStdXml = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public abstract boolean checkStdXml(BeanRootNode var1);

    public abstract String getStdXmlEntry();

    public String getWSStdXmlEntry() {
        return WS_STD_XML_ENTRY;
    }

    public XMLDocument getXmlDocument(String entryName) throws ExtendedRuntimeException {
        if (this._noConfiguration) {
            return null;
        }
        XMLDocument doc = null;
        try {
            doc = XMLUtils.parse(this, entryName, this.getDtdValidationMode());
        }
        catch (ExtendedRuntimeException e) {
            String path = this._entryName == null ? entryName : entryName + " in " + this._entryName;
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("noXMLDoc", new String[]{path}), e);
        }
        return doc;
    }

    public XMLDocument getXmlDocument(String uri, String entryName) throws ExtendedRuntimeException {
        if (this._noConfiguration) {
            return null;
        }
        if (uri != null && uri.length() > 0 && uri.charAt(0) == '/') {
            uri = uri.substring(1);
        }
        XMLDocument doc = null;
        try {
            doc = XMLUtils.parse(uri, this, entryName, this.getDtdValidationMode());
        }
        catch (ExtendedRuntimeException e) {
            String path = this._entryName == null ? entryName : entryName + " in " + this._entryName;
            throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("noXMLDoc", new String[]{path}), e);
        }
        return doc;
    }

    protected boolean checkParam(Object obj, String className) {
        try {
            Class<?> cl = Class.forName(className);
            return cl.isInstance(obj);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public DDBeanRoot getDDBeanRoot() {
        return this._stdXml;
    }

    public DDBeanRoot getDDBeanRoot(String filename) throws FileNotFoundException {
        if (filename.equals(WEB_WS_STD_XML_ENTRY) && this.getType().equals(ModuleType.WAR) || filename.equals(WS_STD_XML_ENTRY)) {
            return this._wsStdXml;
        }
        throw new FileNotFoundException(filename);
    }

    public DDBean[] getChildBean(String xpath) {
        if (xpath.startsWith("/webservices")) {
            if (this._wsStdXml != null) {
                return this._wsStdXml.getChildBean(xpath);
            }
            return null;
        }
        if (this._stdXml != null) {
            return this._stdXml.getChildBean(xpath);
        }
        return null;
    }

    public String[] getText(String xpath) {
        if (xpath.startsWith("/webservices")) {
            if (this._wsStdXml != null) {
                return this._wsStdXml.getText(xpath);
            }
            return null;
        }
        if (this._stdXml != null) {
            return this._stdXml.getText(xpath);
        }
        return null;
    }

    public String getModuleDTDVersion() {
        if (this._stdXml != null && this._stdXml.Desc() != null) {
            return this._stdXml.Desc().getModuleDTDVersion();
        }
        return "";
    }

    public Class getClassFromScope(String className) {
        return null;
    }

    public String getURI() {
        return this._entryName;
    }

    public File getFile() {
        return this._file;
    }

    public J2eeFile getParent() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyToFile(File dest) throws ExtendedRuntimeException {
        FileInputStream inStrm = null;
        try {
            if (this._jarTool == null) {
                this._file = this._parent.getEntryAsFile(this._entryName);
                this._jarTool = new JarTool(this._file);
            }
            try {
                inStrm = new FileInputStream(this._file);
                J2eeFile.copyStreamToFile(inStrm, dest);
            }
            finally {
                if (inStrm != null) {
                    inStrm.close();
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    protected static void copyStreamToFile(InputStream inStrm, File dest) throws ExtendedRuntimeException {
        FileOutputStream outStrm = null;
        try {
            try {
                int read;
                outStrm = new FileOutputStream(dest);
                BufferedInputStream buf = new BufferedInputStream(inStrm, 4096);
                byte[] bytes = new byte[4096];
                while ((read = buf.read(bytes)) != -1) {
                    outStrm.write(bytes, 0, read);
                }
            }
            catch (Throwable t) {
                throw new ExtendedRuntimeException(t);
            }
            finally {
                if (outStrm != null) {
                    outStrm.close();
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }
}

