/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.FormLoginConfigBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoginConfigBean
extends BeanNode {
    public LoginConfigBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getAuthMethod() {
        return this.nodeValue("auth-method");
    }

    public String getRealmName() {
        return this.nodeValue("realm-name");
    }

    public String getFormLoginPage() {
        return this.nodeValue("form-login-page");
    }

    public String getFormErrorPage() {
        return this.nodeValue("form-error-page");
    }

    public String toString() {
        return "login-config";
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "login-config" + ">");
        LoginConfigBean.writeAll(this.getChildBean("auth-method"), out, indentation + "\t");
        LoginConfigBean.writeAll(this.getChildBean("realm-name"), out, indentation + "\t");
        LoginConfigBean.writeAll(this.getChildBean("form-login-config"), out, indentation + "\t");
        out.println(indentation + "</" + "login-config" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("login-config");
        Vector<StringBean> authMethod = new Vector<StringBean>(1);
        Vector<StringBean> realmName = new Vector<StringBean>(1);
        Vector<StringBean> formLoginConfig = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("auth-method")) {
                bean = new StringBean(node, this, "auth-method");
                authMethod.add((StringBean)bean);
                continue;
            }
            if (name.equals("realm-name")) {
                bean = new StringBean(node, this, "realm-name");
                realmName.add((StringBean)bean);
                continue;
            }
            if (!name.equals("form-login-config")) continue;
            bean = new FormLoginConfigBean(node, this);
            formLoginConfig.add((StringBean)bean);
        }
        this.recordXpathForBeans("auth-method", authMethod);
        this.recordXpathForBeans("realm-name", realmName);
        this.recordXpathForBeans("form-login-config", formLoginConfig);
    }
}

