/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDrivenDestinationBean
extends BeanNode {
    public MessageDrivenDestinationBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDestinationType() {
        return this.nodeValue("destination-type");
    }

    public String getSubscriptionDurability() {
        return this.nodeValue("subscription-durability");
    }

    public String toString() {
        return "Message Driven Destination";
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "message-driven-destination" + ">");
        MessageDrivenDestinationBean.writeAll(this.getChildBean("destination-type"), out, indentation + "\t");
        MessageDrivenDestinationBean.writeAll(this.getChildBean("subscription-durability"), out, indentation + "\t");
        out.println(indentation + "</" + "message-driven-destination" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("message-driven-destination");
        Vector<StringBean> destinationType = new Vector<StringBean>(1);
        Vector<StringBean> subscriptionDurability = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("destination-type")) {
                bean = new StringBean(node, this, "destination-type");
                destinationType.add(bean);
            }
            if (!name.equals("subscription-durability")) continue;
            bean = new StringBean(node, this, "subscription-durability");
            subscriptionDurability.add(bean);
        }
        this.recordXpathForBeans("destination-type", destinationType);
        this.recordXpathForBeans("subscription-durability", subscriptionDurability);
    }
}

