/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MimeMappingBean
extends BeanNode {
    public MimeMappingBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getExtension() {
        return this.nodeValue("extension");
    }

    public String getMimeType() {
        return this.nodeValue("mime-type");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "mime-mapping" + ">");
        MimeMappingBean.writeAll(this.getChildBean("extension"), out, indentation + "\t");
        MimeMappingBean.writeAll(this.getChildBean("mime-type"), out, indentation + "\t");
        out.println(indentation + "</" + "mime-mapping" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("mime-mapping");
        Vector<StringBean> extension = new Vector<StringBean>(1);
        Vector<StringBean> mimeType = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("extension")) {
                bean = new StringBean(node, this, "extension");
                extension.add(bean);
                continue;
            }
            if (!name.equals("mime-type")) continue;
            bean = new StringBean(node, this, "mime-type");
            mimeType.add(bean);
        }
        this.recordXpathForBeans("extension", extension);
        this.recordXpathForBeans("mime-type", mimeType);
    }
}

