/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.QueryMethodBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryBean
extends BeanNode {
    public QueryBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getResultTypeMapping() {
        return this.nodeValue("result-type-mapping");
    }

    public String getEjbQl() {
        return this.nodeValue("ejb-ql");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "query-method";
        DDBean[] queryMethod = this.getChildBean(childPath);
        if (queryMethod != null && queryMethod.length > 0) {
            vec.add(queryMethod[0]);
        }
        return vec;
    }

    public String toString() {
        return "Query";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "query" + ">");
        QueryBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        QueryBean.writeAll(this.getChildBean("query-method"), out, indentation + "\t");
        QueryBean.writeAll(this.getChildBean("result-type-mapping"), out, indentation + "\t");
        QueryBean.writeAll(this.getChildBean("ejb-ql"), out, indentation + "\t");
        out.println(indentation + "</" + "query" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("query");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> queryMethod = new Vector<StringBean>(1);
        Vector<StringBean> resultTypeMapping = new Vector<StringBean>(1);
        Vector<StringBean> ejbQl = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("query-method")) {
                bean = new QueryMethodBean(node, this);
                queryMethod.add((StringBean)bean);
            }
            if (name.equals("result-type-mapping")) {
                bean = new StringBean(node, this, "result-type-mapping");
                resultTypeMapping.add((StringBean)bean);
            }
            if (!name.equals("ejb-ql")) continue;
            bean = new StringBean(node, this, "ejb-ql");
            ejbQl.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("query-method", queryMethod);
        this.recordXpathForBeans("result-type-mapping", resultTypeMapping);
        this.recordXpathForBeans("ejb-ql", ejbQl);
    }
}

