/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.RunAsBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityIdentityBean
extends BeanNode {
    public SecurityIdentityBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public boolean isUseCallerIdentity() {
        Vector v = this.resolveXpath("use-caller-identity");
        return v != null && v.size() != 0;
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "run-as";
        DDBean[] runAs = this.getChildBean(childPath);
        if (runAs != null && runAs.length > 0) {
            vec.add(runAs[0]);
        }
        return vec;
    }

    public String toString() {
        return "Security Identity";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "security-identity" + ">");
        SecurityIdentityBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        SecurityIdentityBean.writeAll(this.getChildBean("use-caller-identity"), out, indentation + "\t");
        SecurityIdentityBean.writeAll(this.getChildBean("run-as"), out, indentation + "\t");
        out.println(indentation + "</" + "security-identity" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("security-identity");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> userCallerIdentity = new Vector<StringBean>(1);
        Vector<StringBean> runAs = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("use-caller-identity")) {
                bean = new StringBean(node, this, "use-caller-identity");
                userCallerIdentity.add((StringBean)bean);
            }
            if (!name.equals("run-as")) continue;
            bean = new RunAsBean(node, this);
            runAs.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("use-caller-identity", userCallerIdentity);
        this.recordXpathForBeans("run-as", runAs);
    }
}

