/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.InitParamBean;
import oracle.oc4j.admin.deploy.model.xml.SoapHeaderBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceRefHandlerBean
extends BeanNode {
    public ServiceRefHandlerBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public String getHandlerName() {
        return this.nodeValue("handler-name");
    }

    public String getHandlerClass() {
        return this.nodeValue("handler-class");
    }

    public String getPortName() {
        return this.nodeValue("port-name");
    }

    protected Collection createSpecialJTreeChildren() {
        int j;
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "init-param";
        DDBean[] beans = this.getChildBean(childPath);
        if (beans != null) {
            for (j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        if ((beans = this.getChildBean(childPath = "soap-header")) != null) {
            for (j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        if ((beans = this.getChildBean(childPath = "soap-role")) != null) {
            for (j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "handler" + ">");
        ServiceRefHandlerBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ServiceRefHandlerBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        ServiceRefHandlerBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        out.println(indentation + "</" + "handler" + ">");
    }

    public String jtreeToolTip() {
        return "Service Ref Handler";
    }

    public String toString() {
        String ret = this.getDisplayName();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return "Service Ref Handler";
    }

    private void init(Node rootNode) {
        this.setXpath("handler");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> handlerName = new Vector<IconBean>(1);
        Vector<IconBean> handlerClass = new Vector<IconBean>(1);
        Vector<IconBean> initParam = new Vector<IconBean>(1);
        Vector<IconBean> soapHeader = new Vector<IconBean>(1);
        Vector<IconBean> soapRole = new Vector<IconBean>(1);
        Vector<IconBean> portName = new Vector<IconBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            }
            if (name.equals("handler-name")) {
                bean = new StringBean(node, this, "handler-name");
                handlerName.add((IconBean)bean);
            }
            if (name.equals("handler-class")) {
                bean = new StringBean(node, this, "handler-class");
                handlerClass.add((IconBean)bean);
            }
            if (name.equals("init-param")) {
                bean = new InitParamBean(node, this);
                initParam.add((IconBean)bean);
            }
            if (name.equals("soap-header")) {
                bean = new SoapHeaderBean(node, this);
                soapHeader.add((IconBean)bean);
            }
            if (name.equals("soap-role")) {
                bean = new StringBean(node, this, "soap-role");
                soapRole.add((IconBean)bean);
            }
            if (!name.equals("port-name")) continue;
            bean = new StringBean(node, this, "port-name");
            portName.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("handler-name", handlerName);
        this.recordXpathForBeans("handler-class", handlerClass);
        this.recordXpathForBeans("init-param", initParam);
        this.recordXpathForBeans("soap-header", soapHeader);
        this.recordXpathForBeans("soap-role", soapRole);
        this.recordXpathForBeans("port-name", portName);
    }
}

