/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.EjbLocalRefBean;
import oracle.oc4j.admin.deploy.model.xml.EjbRefBean;
import oracle.oc4j.admin.deploy.model.xml.EnvEntryBean;
import oracle.oc4j.admin.deploy.model.xml.MessageDestinationRefBean;
import oracle.oc4j.admin.deploy.model.xml.ResourceEnvRefBean;
import oracle.oc4j.admin.deploy.model.xml.ResourceRefBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityIdentityBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityRoleRefBean;
import oracle.oc4j.admin.deploy.model.xml.ServiceRefBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionBean
extends BeanNode {
    public SessionBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("large-icon");
    }

    public String getEjbName() {
        return this.nodeValue("ejb-name");
    }

    public String getHome() {
        return this.nodeValue("home");
    }

    public String getRemote() {
        return this.nodeValue("remote");
    }

    public String getLocalHome() {
        return this.nodeValue("local-home");
    }

    public String getLocal() {
        return this.nodeValue("local");
    }

    public String getServiceEndpoint() {
        return this.nodeValue("service-endpoint");
    }

    public String getEjbClass() {
        return this.nodeValue("ejb-class");
    }

    public String getSessionType() {
        return this.nodeValue("session-type");
    }

    public String getTransactionType() {
        return this.nodeValue("transaction-type");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<Object> vec = new Vector<Object>();
        String childPath = "security-identity";
        DDBean[] securityIdentity = this.getChildBean(childPath);
        if (securityIdentity != null && securityIdentity.length > 0) {
            vec.add(securityIdentity[0]);
        }
        vec.add(new CollectionJTreeNode(this, "env-entry", "Environment Entries", true));
        vec.add(new CollectionJTreeNode(this, "ejb-ref", "Ejb Refs", true));
        vec.add(new CollectionJTreeNode(this, "ejb-local-ref", "Ejb Local Refs", true));
        vec.add(new CollectionJTreeNode(this, "service-ref", "Service Refs", true));
        vec.add(new CollectionJTreeNode(this, "security-role-ref", "Security Role Refs", true));
        vec.add(new CollectionJTreeNode(this, "resource-ref", "Resource Refs", true));
        vec.add(new CollectionJTreeNode(this, "resource-env-ref", "Resource Env Refs", true));
        vec.add(new CollectionJTreeNode(this, "message-destination-ref", "Message Destination Refs", true));
        return vec;
    }

    public String jtreeToolTip() {
        return "Session Bean";
    }

    public String toString() {
        String val = this.getDisplayName();
        if (val == null || val.equals("")) {
            val = this.getEjbName();
        }
        return val;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "session" + ">");
        SessionBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("small-icon"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("large-icon"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("ejb-name"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("home"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("remote"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("local-home"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("local"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("service-endpoint"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("ejb-class"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("session-type"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("transaction-type"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("env-entry"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("ejb-ref"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("ejb-local-ref"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("service-ref"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("security-role-ref"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("security-identity"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("resource-ref"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("resource-env-ref"), out, indentation + "\t");
        SessionBean.writeAll(this.getChildBean("message-destination-ref"), out, indentation + "\t");
        out.println(indentation + "</" + "session" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("session");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> displayName = new Vector<StringBean>(1);
        Vector<StringBean> smallIcon = new Vector<StringBean>(1);
        Vector<StringBean> largeIcon = new Vector<StringBean>(1);
        Vector<StringBean> ejbName = new Vector<StringBean>(1);
        Vector<StringBean> home = new Vector<StringBean>(1);
        Vector<StringBean> remote = new Vector<StringBean>(1);
        Vector<StringBean> localHome = new Vector<StringBean>(1);
        Vector<StringBean> local = new Vector<StringBean>(1);
        Vector<StringBean> serviceEndpoint = new Vector<StringBean>(1);
        Vector<StringBean> ejbClass = new Vector<StringBean>(1);
        Vector<StringBean> sessionType = new Vector<StringBean>(1);
        Vector<StringBean> transactionType = new Vector<StringBean>(1);
        Vector<StringBean> envEntries = new Vector<StringBean>();
        Vector<StringBean> ejbRefs = new Vector<StringBean>();
        Vector<StringBean> ejbLocalRefs = new Vector<StringBean>();
        Vector<StringBean> serviceRefs = new Vector<StringBean>();
        Vector<StringBean> securityRoleRefs = new Vector<StringBean>();
        Vector<StringBean> securityIdentity = new Vector<StringBean>();
        Vector<StringBean> resourceRefs = new Vector<StringBean>();
        Vector<StringBean> resourceEnvRefs = new Vector<StringBean>();
        Vector<StringBean> messageDestinationRefs = new Vector<StringBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((StringBean)bean);
            }
            if (name.equals("small-icon")) {
                bean = new StringBean(node, this, "small-icon");
                smallIcon.add((StringBean)bean);
            }
            if (name.equals("large-icon")) {
                bean = new StringBean(node, this, "large-icon");
                largeIcon.add((StringBean)bean);
            }
            if (name.equals("ejb-name")) {
                bean = new StringBean(node, this, "ejb-name");
                ejbName.add((StringBean)bean);
            }
            if (name.equals("home")) {
                bean = new StringBean(node, this, "home");
                home.add((StringBean)bean);
            }
            if (name.equals("remote")) {
                bean = new StringBean(node, this, "remote");
                remote.add((StringBean)bean);
            }
            if (name.equals("local-home")) {
                bean = new StringBean(node, this, "local-home");
                localHome.add((StringBean)bean);
            }
            if (name.equals("local")) {
                bean = new StringBean(node, this, "local");
                local.add((StringBean)bean);
            }
            if (name.equals("service-endpoint")) {
                bean = new StringBean(node, this, "service-endpoint");
                serviceEndpoint.add((StringBean)bean);
            }
            if (name.equals("ejb-class")) {
                bean = new StringBean(node, this, "ejb-class");
                ejbClass.add((StringBean)bean);
            }
            if (name.equals("session-type")) {
                bean = new StringBean(node, this, "session-type");
                sessionType.add((StringBean)bean);
            }
            if (name.equals("transaction-type")) {
                bean = new StringBean(node, this, "transaction-type");
                transactionType.add((StringBean)bean);
            }
            if (name.equals("env-entry")) {
                bean = new EnvEntryBean(node, this);
                envEntries.add((StringBean)bean);
            }
            if (name.equals("ejb-ref")) {
                bean = new EjbRefBean(node, this);
                ejbRefs.add((StringBean)bean);
            }
            if (name.equals("ejb-local-ref")) {
                bean = new EjbLocalRefBean(node, this);
                ejbLocalRefs.add((StringBean)bean);
            }
            if (name.equals("service-ref")) {
                bean = new ServiceRefBean(node, this);
                serviceRefs.add((StringBean)bean);
            }
            if (name.equals("security-role-ref")) {
                bean = new SecurityRoleRefBean(node, this);
                securityRoleRefs.add((StringBean)bean);
            }
            if (name.equals("security-identity")) {
                bean = new SecurityIdentityBean(node, this);
                securityIdentity.add((StringBean)bean);
            }
            if (name.equals("resource-ref")) {
                bean = new ResourceRefBean(node, this);
                resourceRefs.add((StringBean)bean);
            }
            if (name.equals("resource-env-ref")) {
                bean = new ResourceEnvRefBean(node, this);
                resourceEnvRefs.add((StringBean)bean);
            }
            if (!name.equals("message-destination-ref")) continue;
            bean = new MessageDestinationRefBean(node, this);
            messageDestinationRefs.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("small-icon", smallIcon);
        this.recordXpathForBeans("large-icon", largeIcon);
        this.recordXpathForBeans("ejb-name", ejbName);
        this.recordXpathForBeans("home", home);
        this.recordXpathForBeans("remote", remote);
        this.recordXpathForBeans("local-home", localHome);
        this.recordXpathForBeans("local", local);
        this.recordXpathForBeans("service-endpoint", serviceEndpoint);
        this.recordXpathForBeans("ejb-class", ejbClass);
        this.recordXpathForBeans("session-type", sessionType);
        this.recordXpathForBeans("transaction-type", transactionType);
        this.recordXpathForBeans("env-entry", envEntries);
        this.recordXpathForBeans("ejb-ref", ejbRefs);
        this.recordXpathForBeans("ejb-local-ref", ejbLocalRefs);
        this.recordXpathForBeans("service-ref", serviceRefs);
        this.recordXpathForBeans("security-role-ref", securityRoleRefs);
        this.recordXpathForBeans("security-identity", securityIdentity);
        this.recordXpathForBeans("resource-ref", resourceRefs);
        this.recordXpathForBeans("resource-env-ref", resourceEnvRefs);
        this.recordXpathForBeans("message-destination-ref", messageDestinationRefs);
    }
}

