/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebResourceCollectionBean
extends BeanNode {
    public WebResourceCollectionBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getWebResourceName() {
        return this.nodeValue("web-resource-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getUrlPatterns() {
        return this.allNodesValue("url-pattern");
    }

    public String getHttpMethods() {
        return this.allNodesValue("http-method");
    }

    public String jtreeToolTip() {
        return "Web Resource Collection";
    }

    public String toString() {
        return this.getWebResourceName();
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "web-resource-collection" + ">");
        WebResourceCollectionBean.writeAll(this.getChildBean("web-resource-name"), out, indentation + "\t");
        WebResourceCollectionBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        WebResourceCollectionBean.writeAll(this.getChildBean("url-pattern"), out, indentation + "\t");
        WebResourceCollectionBean.writeAll(this.getChildBean("http-method"), out, indentation + "\t");
        out.println(indentation + "</" + "web-resource-collection" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("web-resource-collection");
        Vector<StringBean> webResourceName = new Vector<StringBean>(1);
        Vector<StringBean> desc = new Vector<StringBean>(1);
        Vector<StringBean> urlPatterns = new Vector<StringBean>();
        Vector<StringBean> httpMethods = new Vector<StringBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("web-resource-name")) {
                bean = new StringBean(node, this, "web-resource-name");
                webResourceName.add(bean);
                continue;
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                desc.add(bean);
                continue;
            }
            if (name.equals("url-pattern")) {
                bean = new StringBean(node, this, "url-pattern");
                urlPatterns.add(bean);
                continue;
            }
            if (!name.equals("http-method")) continue;
            bean = new StringBean(node, this, "http-method");
            httpMethods.add(bean);
        }
        this.recordXpathForBeans("web-resource-name", webResourceName);
        this.recordXpathForBeans("description", desc);
        this.recordXpathForBeans("url-pattern", urlPatterns);
        this.recordXpathForBeans("http-method", httpMethods);
    }
}

