/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.model.xml.WebServiceDescriptionBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebServicesBean
extends BeanNode {
    public WebServicesBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "webservice-description";
        DDBean[] beans = this.getChildBean(childPath);
        if (beans != null) {
            for (int j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "webservices" + ">");
        WebServicesBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        WebServicesBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        WebServicesBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        WebServicesBean.writeAll(this.getChildBean("webservice-description"), out, indentation + "\t");
        out.println(indentation + "</" + "webservices" + ">");
    }

    public String jtreeToolTip() {
        return "Web Services";
    }

    public String toString() {
        String ret = this.getDisplayName();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return "Web Services";
    }

    private void init(Node rootNode) {
        this.setXpath("webservices");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> webServiceDesc = new Vector<IconBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            }
            if (!name.equals("webservice-description")) continue;
            bean = new WebServiceDescriptionBean(node, this);
            webServiceDesc.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("webservice-description", webServiceDesc);
    }
}

