/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.j2ee.Management;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.shell.ShellHandler;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.factories.IasDeploymentFactory;
import oracle.oc4j.admin.deploy.spi.factories.Oc4jDeploymentFactory;
import oracle.oc4j.admin.jmx.client.IasDomainFactory;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.management.mejb.MEjbFactory;

public class AdminShell {
    private static Logger logger_ = TraceLogger.getLogger((Class)AdminShell.class);
    private static String deployerUrl = null;
    private static String DEFAULTDOMAIN = "oc4j";
    private static String DEFAULTHOST = "localhost";
    private static String DEFAULTPORT = "23791";
    private static String domain = DEFAULTDOMAIN;
    private static String host = DEFAULTHOST;
    private static String port = DEFAULTPORT;
    private static String userName = null;
    private static String password = null;
    private static Management _mejb;
    private static DeploymentManager _deployer;
    private static ProprietaryConnectedDeploymentManager _pcDeplMgr;
    private static ConnectedDeploymentManagerBase _cDeplMgrBase;
    private static String deployUrl;
    private static String token;
    private static int[] index;
    private static boolean iasDomain_;

    public static void main(String[] argumentArray) {
        block14: {
            try {
                ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(argumentArray));
                try {
                    deployerUrl = AdminShell.getNextArgumentFromCommandLine(arguments, "deployer url or ormi url or -command");
                    if (deployerUrl == null || !deployerUrl.startsWith("deployer:") && !deployerUrl.startsWith("ormi:")) {
                        AdminShell.usage("Missing deployer: or ormi:");
                        System.exit(1);
                    }
                    if (deployerUrl.startsWith("deployer:")) {
                        deployerUrl = AdminShell.getDeployerUrl(deployerUrl);
                    } else if (deployerUrl.startsWith("ormi:")) {
                        System.out.println("Use backward compatibility format: java -jar admin.jar ormi://...");
                    }
                    userName = AdminShell.getNextArgumentFromCommandLine(arguments, "username");
                    password = AdminShell.getNextArgumentFromCommandLine(arguments, "password");
                    Hashtable environment = new Hashtable();
                    Domain domain = AdminShell.getDomain(host, port, userName, password);
                    _mejb = AdminShell.getManagement(domain);
                    if (_mejb == null) {
                        System.err.println("Unable to locate the MBean Server");
                        System.exit(1);
                    }
                    if ((_deployer = AdminShell.getDeploymentManager(deployerUrl, userName, password)) == null) {
                        System.err.println("Unable to locate the deployer");
                        System.exit(1);
                    } else {
                        _pcDeplMgr = (ProprietaryConnectedDeploymentManager)_deployer;
                        _cDeplMgrBase = (ConnectedDeploymentManagerBase)_deployer;
                    }
                    String command = AdminShell.getNextArgumentFromCommandLine(arguments, "command");
                    if (command.equals("-shell")) {
                        ShellHandler shellHandler = new ShellHandler();
                        shellHandler.handleShellCommand(arguments);
                        break block14;
                    }
                    AdminShell.usage("Unknown switch: " + command);
                }
                catch (SecurityException e) {
                    System.err.println("Security error: " + e.getMessage());
                    AdminShell.doExit();
                }
                catch (Throwable t) {
                    System.err.println("Error: " + t);
                    if ("debug".equalsIgnoreCase(System.getProperty("mode"))) {
                        t.printStackTrace();
                    }
                    AdminShell.doExit();
                }
            }
            catch (IllegalArgumentException e) {
                AdminShell.usage(e.getMessage());
            }
        }
    }

    static void usage(String message) {
        if (message != null) {
            System.err.println(message);
        }
    }

    public static String getNextArgumentFromCommandLine(List arguments, String argumentDescription) {
        if (arguments.isEmpty()) {
            AdminShell.usage("");
            AdminShell.usage("Invalid usage: " + (argumentDescription == null ? "Missing argument" : "Missing " + argumentDescription));
            AdminShell.usage("");
            AdminShell.usage("Usage: java -classpath admin_client.jar oracle.oc4j.admin.deploy.shell.AdminShell ");
            AdminShell.usage("       deployer:[oc4j|ias][[:]host][[:]port] login password -shell");
            AdminShell.usage("");
            System.exit(1);
        }
        return (String)arguments.remove(0);
    }

    public static String getNextArgumentFromShell(List arguments, String argumentDescription) {
        if (arguments.isEmpty()) {
            AdminShell.usage("Invalid usage: " + (argumentDescription == null ? "Missing argument" : "Missing " + argumentDescription));
            return null;
        }
        return (String)arguments.remove(0);
    }

    private static String getDeployerUrl(String url) {
        boolean userProvided = false;
        AdminShell.index[0] = 0;
        userProvided = AdminShell.getTitle(url);
        userProvided = AdminShell.getDomain(userProvided, url);
        userProvided = AdminShell.getHost(userProvided, url);
        userProvided = AdminShell.getPort(userProvided, url);
        return AdminShell.getUrl();
    }

    private static boolean getTitle(String url) {
        token = AdminShell.getToken(url, index);
        if (token.equalsIgnoreCase("deployer")) {
            AdminShell.concatUrl(token + ":");
            return true;
        }
        if (token.equalsIgnoreCase("ormi")) {
            return true;
        }
        AdminShell.concatUrl("deployer:");
        return false;
    }

    private static boolean getDomain(boolean userProvided, String url) {
        if (userProvided) {
            token = AdminShell.getToken(url, index);
        }
        if (token.equalsIgnoreCase("ias")) {
            iasDomain_ = true;
        }
        if (token != null && (token.equalsIgnoreCase("oc4j") || token.equalsIgnoreCase("ias"))) {
            AdminShell.concatUrl(token + ":");
            domain = token;
            return true;
        }
        AdminShell.concatUrl(DEFAULTDOMAIN + ":");
        return false;
    }

    private static boolean getHost(boolean userProvided, String url) {
        if (userProvided) {
            token = AdminShell.getToken(url, index);
        }
        if (token != null && !token.equals("")) {
            try {
                Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                AdminShell.concatUrl(token + ":");
                host = token;
                return true;
            }
        }
        AdminShell.concatUrl(DEFAULTHOST + ":");
        return false;
    }

    private static boolean getPort(boolean userProvided, String url) {
        if (userProvided) {
            token = AdminShell.getToken(url, index);
        }
        if (token != null && !token.equals("")) {
            AdminShell.concatUrl(token);
            port = token;
            return true;
        }
        AdminShell.concatUrl(DEFAULTPORT);
        return false;
    }

    private static String getToken(String url, int[] index) {
        try {
            int pos = url.indexOf(58, index[0]);
            if (pos != -1) {
                token = url.substring(index[0], pos);
                index[0] = pos + 1;
            } else {
                token = url.substring(index[0]);
                index[0] = index[0] + token.length();
            }
        }
        catch (IndexOutOfBoundsException e) {
            token = null;
        }
        return token;
    }

    private static void concatUrl(String url) {
        deployUrl = deployUrl.concat(url);
    }

    private static String getUrl() {
        return deployUrl;
    }

    private static Management getManagement(Domain domain) {
        try {
            return MEjbFactory.getManagement(domain);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static DeploymentManager getDeploymentManager(String deployUrl, String login, String password) {
        DeploymentFactoryManager depFactManager = AdminShell.getDeploymentFactoryManager();
        try {
            return depFactManager.getDeploymentManager(deployUrl, login, password);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Domain getDomain(String host, String hostPort, String user, String passwd) {
        try {
            int port = Integer.parseInt(hostPort);
            InetAddress serverHost = InetAddress.getByName(host);
            Domain domain = null;
            domain = iasDomain_ ? IasDomainFactory.getDomain(host, port, user, passwd) : Oc4jDomainFactory.getDomain(host, port, user, passwd);
            return domain;
        }
        catch (Exception e) {
            System.err.println("Unable to get Domain: " + e.getMessage());
            return null;
        }
    }

    private static DeploymentFactoryManager getDeploymentFactoryManager() {
        DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
        mgr.registerDeploymentFactory((DeploymentFactory)new Oc4jDeploymentFactory());
        mgr.registerDeploymentFactory((DeploymentFactory)new IasDeploymentFactory());
        return mgr;
    }

    static Management getManagement() {
        return _mejb;
    }

    static DeploymentManager getDeploymentManager() {
        return _deployer;
    }

    static ProprietaryConnectedDeploymentManager getProprietaryConnectedDeplManag() {
        return _pcDeplMgr;
    }

    static ConnectedDeploymentManagerBase getConnectedDeplMgrBase() {
        return _cDeplMgrBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void doExit() {
        block15: {
            block14: {
                if (_mejb == null) break block14;
                _mejb.remove();
                _mejb = null;
            }
            Object var2 = null;
            try {
                if (_deployer != null) {
                    _deployer.release();
                    _deployer = null;
                }
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                System.err.println("Unable to remove the deployment manager." + e2.getMessage());
                if (logger_.isLoggable(Level.SEVERE)) {
                    logger_.log(Level.SEVERE, "Unable to remove the deployment manager." + e2.getMessage(), e2);
                }
                break block15;
            }
            {
                catch (Exception e) {
                    System.err.println("Unable to remove the MBean Server" + e.getMessage());
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, "Unable to remove the MBean Server" + e.getMessage(), e);
                    }
                    Object var2_1 = null;
                    try {
                        if (_deployer != null) {
                            _deployer.release();
                            _deployer = null;
                        }
                        Thread.sleep(2000L);
                    }
                    catch (Exception e2) {
                        System.err.println("Unable to remove the deployment manager." + e2.getMessage());
                        if (logger_.isLoggable(Level.SEVERE)) {
                            logger_.log(Level.SEVERE, "Unable to remove the deployment manager." + e2.getMessage(), e2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block16: {
                    Object var2_2 = null;
                    try {
                        if (_deployer != null) {
                            _deployer.release();
                            _deployer = null;
                        }
                        Thread.sleep(2000L);
                    }
                    catch (Exception e2) {
                        System.err.println("Unable to remove the deployment manager." + e2.getMessage());
                        if (!logger_.isLoggable(Level.SEVERE)) break block16;
                        logger_.log(Level.SEVERE, "Unable to remove the deployment manager." + e2.getMessage(), e2);
                    }
                }
                throw throwable;
            }
        }
        System.exit(1);
    }

    static {
        deployUrl = "";
        token = null;
        index = new int[1];
        iasDomain_ = false;
    }
}

