/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.shell.AdminShell;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.TargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.status.DeployProgressListenerWriter;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.SharedModuleType;

class CommandHandler {
    CommandHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean handleDeployment(List arguments, SharedModuleType type) {
        String fileName = null;
        String applicationName = null;
        String argument = null;
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        boolean force = false;
        int pos = 4;
        while (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "deployment subcommand");
            if (command == null) {
                return false;
            }
            if (command.equalsIgnoreCase("-file")) {
                fileName = AdminShell.getNextArgumentFromShell(arguments, "deployment -file filename");
                if (fileName != null) continue;
                return false;
            }
            if (command.equalsIgnoreCase("-cluster")) {
                extraParameters.put("cluster", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-targetPath")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "-targetPath argument");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("targetPath", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentName")) {
                applicationName = AdminShell.getNextArgumentFromShell(arguments, "deployment name");
                if (applicationName != null) continue;
                return false;
            }
            if (command.equalsIgnoreCase("-bindWebApp")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "bindWebApp web site name");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("bindWebApp", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-pedantic")) {
                extraParameters.put("pedantic", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-parent")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "-parent argument");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("parent", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentDirectory")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "-deploymentDirectory");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("deploymentDirectory", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-autoCreateTables")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "-autoCreateTables");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("autoCreateTables", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-contextRoot")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "-contextRoot");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("contextRoot", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-nativeLibPath")) {
                argument = AdminShell.getNextArgumentFromShell(arguments, "nativelibrary native library directory");
                if (argument == null) {
                    return false;
                }
                extraParameters.put("nativeLibPath", argument);
                continue;
            }
            if (command.equalsIgnoreCase("-grantAllPermissions")) {
                extraParameters.put("grantAllPermissions", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-force")) {
                force = true;
                continue;
            }
            AdminShell.usage("Error: Unknown -deploy switch: " + command);
            return false;
        }
        if (fileName == null) {
            System.err.println("Error: -file <name> not specified");
            System.err.println("Please execute command \"help <command>\" for the command usage.");
            return false;
        }
        if (applicationName == null) {
            System.err.println("Error: -deploymentName <name> not specified");
            System.err.println("Please execute command \"help <command>\" for the command usage.");
            return false;
        }
        try {
            FileInputStream earStream = new FileInputStream(new File(fileName));
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            System.out.println("Module Type is " + extension);
            if (!extension.equalsIgnoreCase(type.toString())) {
                System.err.println("The file associated with type " + extension + " can not be deployed by this command.");
                return false;
            }
            if (type.toString().equalsIgnoreCase("WAR")) {
                boolean rootSet = false;
                boolean websiteSet = false;
                if (!(extraParameters == null || extraParameters.containsKey("contextRoot") && extraParameters.containsKey("bindWebApp"))) {
                    System.err.println("Error: -contextRoot <root> and -bindWebApp <web-site> not specified");
                    System.err.println("       they should be specified at the same time");
                    System.err.println("Please execute command \"help <command>\" for the command usage.");
                    return false;
                }
            }
            ByteArrayInputStream bin = CommandHandler.getDeploymentPlan(applicationName, extraParameters, type);
            String deploymentMonitor = type.toString() + "deploymentMonitor";
            ProprietaryConnectedDeploymentManager pcDeplMgr = AdminShell.getProprietaryConnectedDeplManag();
            String string = deploymentMonitor;
            synchronized (string) {
                DeployProgressListenerWriter listener = new DeployProgressListenerWriter((OutputStream)System.out, (Object)deploymentMonitor);
                if (force) {
                    TargetModuleID[] tids = CommandHandler.getTargetModuleID(applicationName, type.isRar());
                    pcDeplMgr.redeploy(tids, earStream, (InputStream)bin, (ProgressListener)listener);
                } else {
                    pcDeplMgr.distribute(AdminShell.getDeploymentManager().getTargets(), earStream, (InputStream)bin, (ProgressListener)listener);
                }
                deploymentMonitor.wait();
            }
        }
        catch (Exception e) {
            System.err.println("Error deploying: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean handleUnDeployment(List arguments) {
        String appName = null;
        boolean isConnector = false;
        boolean keepFiles = false;
        if (arguments.isEmpty()) {
            AdminShell.usage("Missing application's name after -undeploy switch");
            return false;
        }
        appName = AdminShell.getNextArgumentFromShell(arguments, "un-deployment j2ee application's name");
        if (appName == null) {
            return false;
        }
        if (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "un-deployment subcommand");
            if (command == null) {
                return false;
            }
            if (command.equalsIgnoreCase("-keepFiles")) {
                keepFiles = true;
            } else {
                if (!command.equalsIgnoreCase("-isConnector")) {
                    AdminShell.usage("Unknown -undeploy switch: " + command);
                    return false;
                }
                isConnector = true;
            }
        }
        ProprietaryConnectedDeploymentManager pcDeplMgr = AdminShell.getProprietaryConnectedDeplManag();
        try {
            String undeploymentMonitor;
            String string = undeploymentMonitor = "undeploymentMonitor";
            synchronized (string) {
                DeployProgressListenerWriter listener = new DeployProgressListenerWriter((OutputStream)System.out, (Object)undeploymentMonitor);
                TargetModuleID[] tids = CommandHandler.getTargetModuleID(appName, isConnector);
                pcDeplMgr.undeploy(tids, listener);
                undeploymentMonitor.wait();
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error undeploying application " + appName + ": " + e.getMessage());
            return false;
        }
    }

    static boolean handleShutdown(List arguments) {
        return false;
    }

    static boolean handleRestart(List arguments) {
        return false;
    }

    static boolean handleBindWebModule(List arguments) {
        String applicationName = null;
        String webModuleName = null;
        String webSiteName = null;
        String contextRoot = null;
        while (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "bind subcommand");
            if (command.equalsIgnoreCase("-app")) {
                applicationName = AdminShell.getNextArgumentFromShell(arguments, "app filename");
                continue;
            }
            if (command.equalsIgnoreCase("-module")) {
                webModuleName = AdminShell.getNextArgumentFromShell(arguments, "web module name");
                continue;
            }
            if (command.equalsIgnoreCase("-site")) {
                webSiteName = AdminShell.getNextArgumentFromShell(arguments, "web site name");
                continue;
            }
            if (command.equalsIgnoreCase("-root")) {
                contextRoot = AdminShell.getNextArgumentFromShell(arguments, "context root");
                continue;
            }
            AdminShell.usage("Error: Unknown bind switch: " + command);
            return false;
        }
        if (applicationName == null) {
            System.err.println("Error: no application name specified.");
            return false;
        }
        if (webModuleName == null) {
            System.err.println("Error: no web module specified.");
            return false;
        }
        if (webSiteName == null) {
            System.err.println("Error: no web site specified.");
            return false;
        }
        if (contextRoot == null) {
            System.err.println("Error: no context root specified.");
            return false;
        }
        try {
            ConnectedDeploymentManagerBase cDeplMgrBase = AdminShell.getConnectedDeplMgrBase();
            TargetModuleIDImpl moduleID = CommandHandler.getTargetModuleID(applicationName, webModuleName);
            cDeplMgrBase.bindWebApp((TargetModuleID)moduleID, webSiteName, contextRoot);
        }
        catch (Exception e) {
            System.err.println("Error binding: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean handleBindApp(List arguments) {
        String applicationName = null;
        String webSiteName = null;
        while (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "bind subcommand");
            if (command.equalsIgnoreCase("-app")) {
                applicationName = AdminShell.getNextArgumentFromShell(arguments, "application name");
                continue;
            }
            if (command.equalsIgnoreCase("-site")) {
                webSiteName = AdminShell.getNextArgumentFromShell(arguments, "web site name");
                continue;
            }
            AdminShell.usage("Error: Unknown bind switch: " + command);
            return false;
        }
        if (applicationName == null) {
            System.err.println("Error: no application name specified.");
            return false;
        }
        if (webSiteName == null) {
            System.err.println("Error: no web site specified.");
            return false;
        }
        try {
            ConnectedDeploymentManagerBase cDeplMgrBase = AdminShell.getConnectedDeplMgrBase();
            TargetModuleIDImpl moduleID = CommandHandler.getTargetModuleID(applicationName);
            cDeplMgrBase.bindWebApp(moduleID, webSiteName);
        }
        catch (Exception e) {
            System.err.println("Error binding: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean handleListApps(List arguments) {
        int i;
        int TYPENUM = 5;
        int TITLENUM = 5;
        String theType = new String();
        String[] j2eeType = new String[5];
        j2eeType[0] = "oc4j:j2eeType=J2EEApplication,*";
        j2eeType[1] = "oc4j:j2eeType=EJBModule,*";
        j2eeType[2] = "oc4j:j2eeType=WebModule,*";
        j2eeType[3] = "oc4j:j2eeType=AppClientModule,*";
        String[] title = new String[]{"j2eeType", "name", "JDBCResource", "J2EEApplication", "J2EEServer"};
        System.out.println(title[0] + "              " + title[1] + "                      " + title[2] + "   " + title[3] + "   " + title[4]);
        System.out.println("------------------------------------------------------------------------------------------");
        String type = arguments.isEmpty() ? null : AdminShell.getNextArgumentFromShell(arguments, "j2ee type");
        String option = null;
        try {
            if (type != null && !type.equalsIgnoreCase("-all")) {
                if (type.equalsIgnoreCase("-app")) {
                    String string = option = arguments.isEmpty() ? null : AdminShell.getNextArgumentFromShell(arguments, "j2ee application");
                    if (option != null) {
                        j2eeType[4] = "oc4j:J2EEApplication=" + option + ",*";
                        theType = j2eeType[4];
                    } else {
                        theType = j2eeType[0];
                    }
                } else if (type.equalsIgnoreCase("-ejb")) {
                    theType = j2eeType[1];
                } else if (type.equalsIgnoreCase("-web")) {
                    theType = j2eeType[2];
                } else if (type.equalsIgnoreCase("-appClient")) {
                    theType = j2eeType[3];
                } else {
                    if (type.equalsIgnoreCase("-resource")) {
                        if (!CommandHandler.listResource()) return false;
                        return true;
                    }
                    if (!type.equalsIgnoreCase("-JDBCResource")) {
                        System.out.println("Unknown command options. \n");
                        System.out.println("Please execute command \"help list\" to get  more details on this command.");
                        return false;
                    }
                    String string = option = arguments.isEmpty() ? null : AdminShell.getNextArgumentFromShell(arguments, "JDBC resource");
                    if (option == null) {
                        System.out.println("Please specify the JDBCResource name.");
                        return false;
                    }
                    j2eeType[4] = "oc4j:JDBCResource=" + option + ",*";
                    theType = j2eeType[4];
                }
                Set deployed_apps = AdminShell.getManagement().queryNames(new ObjectName(theType), null);
                if (deployed_apps.size() == 0) {
                    System.out.println("No deployed applications or modules found.");
                    return true;
                }
                Iterator iter = deployed_apps.iterator();
                CommandHandler.parseType(iter);
                return true;
            }
            i = 0;
        }
        catch (Throwable e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        while (i < 5) {
            Set deployed_apps;
            if (j2eeType[i] != null && (deployed_apps = AdminShell.getManagement().queryNames(new ObjectName(j2eeType[i]), null)).size() != 0) {
                Iterator iter = deployed_apps.iterator();
                CommandHandler.parseType(iter);
            }
            ++i;
        }
        return true;
    }

    private static boolean listResource() {
        int RESOURCETYPE = 4;
        String[] theType = new String[]{"oc4j:j2eeType=JavaMailResource,*", "oc4j:j2eeType=JDBCResource,*", "oc4j:j2eeType=JMSResource,*", "oc4j:j2eeType=URLResource,*"};
        try {
            for (int i = 0; i < 4; ++i) {
                Set deployed_apps = AdminShell.getManagement().queryNames(new ObjectName(theType[i]), null);
                if (deployed_apps.size() == 0) continue;
                Iterator iter = deployed_apps.iterator();
                CommandHandler.parseType(iter);
            }
        }
        catch (Throwable e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void parseType(Iterator iter) {
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            String str = iter.next().toString();
            int titleNum = 5;
            String[] content = new String[titleNum];
            String[] a = new String[titleNum];
            String[] b = new String[titleNum];
            int start = 0;
            int end = 0;
            int i = 0;
            String domainName = str.substring(start, str.indexOf(":"));
            str = str.substring(str.indexOf(":") + 1);
            while ((start = str.indexOf("=", start)) >= 0) {
                a[i] = str.substring(0, start);
                end = str.indexOf(",", start);
                if (end < 0) {
                    b[i] = str.substring(start + 1);
                    break;
                }
                b[i] = str.substring(start + 1, end);
                ++i;
                str = str.substring(end + 1);
                start = 0;
            }
            for (i = 0; i < titleNum; ++i) {
                if (a[i] == null) continue;
                if (a[i].equalsIgnoreCase("j2eeType")) {
                    content[0] = b[i];
                    continue;
                }
                if (a[i].equalsIgnoreCase("name")) {
                    content[1] = b[i];
                    continue;
                }
                if (a[i].equalsIgnoreCase("JDBCResource")) {
                    content[2] = b[i];
                    continue;
                }
                if (a[i].equalsIgnoreCase("J2EEApplication")) {
                    content[3] = b[i];
                    continue;
                }
                if (!a[i].equalsIgnoreCase("J2EEServer")) continue;
                content[4] = b[i];
            }
            int column1 = 20;
            int column2 = 32;
            int column3 = 14;
            int column4 = 16;
            for (i = 0; i < titleNum; ++i) {
                System.out.print(content[i]);
                int len = content[i] != null ? (i == 0 ? column1 - content[i].length() : (i == 1 ? column2 - content[i].length() : (i == 2 ? column3 - content[i].length() : (i == 3 ? column4 - content[i].length() : 0)))) : (i == 0 ? column1 - 4 : (i == 1 ? column2 - 4 : (i == 2 ? column3 - 4 : (i == 3 ? column4 - 4 : 0))));
                for (int k = 0; k < len; ++k) {
                    System.out.print(" ");
                }
            }
            System.out.println("");
        }
    }

    private static ByteArrayInputStream getDeploymentPlan(String appName, Map extraParams, SharedModuleType moduleType) {
        String tmp = "applicationID=" + appName + "\n";
        tmp = tmp + "moduleType=" + moduleType + "\n";
        if (extraParams != null) {
            Iterator it = extraParams.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)extraParams.get(key);
                tmp = tmp + key + "=" + value + "\n";
            }
        }
        return new ByteArrayInputStream(tmp.getBytes());
    }

    private static TargetModuleID[] getTargetModuleID(String deployName, boolean isConnector) {
        ObjectName name = isConnector ? ObjectNameFactory.create("oc4j:j2eeType=ResourceAdapterModule,name=" + deployName + ",J2EEApplication=default,J2EEServer=" + "standalone") : ObjectNameFactory.create("oc4j:j2eeType=J2EEApplication,name=" + deployName + ",J2EEServer=" + "standalone");
        TargetModuleIDImpl tid = new TargetModuleIDImpl(AdminShell.getManagement(), name);
        TargetModuleID[] result = new TargetModuleID[]{tid};
        return result;
    }

    private static TargetModuleIDImpl getTargetModuleID(String appName, String webModuleName) {
        ObjectName name = ObjectNameFactory.create("oc4j:j2eeType=WebModule,name=" + webModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + "standalone");
        TargetModuleIDImpl tid = new TargetModuleIDImpl(AdminShell.getManagement(), name);
        return tid;
    }

    private static TargetModuleIDImpl getTargetModuleID(String appName) {
        ObjectName name = ObjectNameFactory.create("oc4j:j2eeType=J2EEApplication,name=" + appName + ",J2EEServer=" + "standalone");
        TargetModuleIDImpl tid = new TargetModuleIDImpl(AdminShell.getManagement(), name);
        return tid;
    }

    private static ObjectName[] getObjectNameForPattern(String objectNamePattern, Management mejb) {
        try {
            ObjectName targetPattern = ObjectNameFactory.create(objectNamePattern);
            Set targets = mejb.queryNames(targetPattern, null);
            ObjectName[] objectNameArray = new ObjectName[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                objectNameArray[targetCount++] = (ObjectName)iter.next();
            }
            return objectNameArray;
        }
        catch (Exception e) {
            System.err.println("Error getting object name: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

