/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import oracle.oc4j.admin.deploy.shell.AdminShell;
import oracle.oc4j.admin.deploy.spi.TargetModuleIDImpl;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.SharedModuleType;

class DeployerUtils {
    private String fileName = null;
    private String applicationNameForDeploy = null;
    private String argument = null;
    private boolean force = false;
    private Map extraParameters = new HashMap();
    private String appNameForUndeploy = null;
    private boolean isConnector = false;
    private boolean keepFiles = false;
    private boolean undeployParamSuccess = true;
    private boolean deployParamSuccess = true;

    DeployerUtils() {
    }

    void processDeployParameters(List arguments) {
        while (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "deployment subcommand");
            if (command == null) {
                this.deployParamSuccess = false;
                return;
            }
            if (command.equalsIgnoreCase("-file")) {
                this.fileName = AdminShell.getNextArgumentFromShell(arguments, "deployment -file filename");
                if (this.fileName != null) continue;
                this.deployParamSuccess = false;
                return;
            }
            if (command.equalsIgnoreCase("-cluster")) {
                this.extraParameters.put("cluster", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-targetPath")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "-targetPath argument");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("targetPath", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentName")) {
                this.applicationNameForDeploy = AdminShell.getNextArgumentFromShell(arguments, "deployment name");
                if (this.applicationNameForDeploy != null) continue;
                this.deployParamSuccess = false;
                return;
            }
            if (command.equalsIgnoreCase("-bindWebApp")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "bindWebApp web site name");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("bindWebApp", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-pedantic")) {
                this.extraParameters.put("pedantic", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-parent")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "-parent argument");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("parent", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentDirectory")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "-deploymentDirectory");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("deploymentDirectory", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-autoCreateTables")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "-autoCreateTables");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("autoCreateTables", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-contextRoot")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "-contextRoot");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("contextRoot", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-nativeLibPath")) {
                this.argument = AdminShell.getNextArgumentFromShell(arguments, "nativelibrary native library directory");
                if (this.argument == null) {
                    this.deployParamSuccess = false;
                    return;
                }
                this.extraParameters.put("nativeLibPath", this.argument);
                continue;
            }
            if (command.equalsIgnoreCase("-grantAllPermissions")) {
                this.extraParameters.put("grantAllPermissions", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-force")) {
                this.force = true;
                continue;
            }
            AdminShell.usage("Error: Unknown -deploy switch: " + command);
            this.deployParamSuccess = false;
            return;
        }
        if (this.fileName == null) {
            System.err.println("Error: -file <name> not specified");
            System.err.println("Please execute command \"help <command>\" for the command usage.");
            this.deployParamSuccess = false;
            return;
        }
        if (this.applicationNameForDeploy == null) {
            System.err.println("Error: -deploymentName <name> not specified");
            System.err.println("Please execute command \"help <command>\" for the command usage.");
            this.deployParamSuccess = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void processUndeployParameters(List arguments) {
        if (arguments.isEmpty()) {
            AdminShell.usage("Missing application's name after -undeploy switch");
            this.undeployParamSuccess = false;
            return;
        }
        this.appNameForUndeploy = AdminShell.getNextArgumentFromShell(arguments, "un-deployment j2ee application's name");
        if (this.appNameForUndeploy == null) {
            this.undeployParamSuccess = false;
            return;
        }
        if (arguments.isEmpty()) return;
        String command = AdminShell.getNextArgumentFromShell(arguments, "un-deployment subcommand");
        if (command == null) {
            this.undeployParamSuccess = false;
            return;
        }
        if (command.equalsIgnoreCase("-keepFiles")) {
            this.keepFiles = true;
            return;
        }
        if (command.equalsIgnoreCase("-isConnector")) {
            this.isConnector = true;
            return;
        }
        AdminShell.usage("Unknown -undeploy switch: " + command);
        this.undeployParamSuccess = false;
    }

    boolean isDeployParamSuccess() {
        return this.deployParamSuccess;
    }

    String getFileName() {
        return this.fileName;
    }

    String getAppNameForDeploy() {
        return this.applicationNameForDeploy;
    }

    Map getExtraParameters() {
        return this.extraParameters;
    }

    boolean getForce() {
        return this.force;
    }

    boolean isUndeployParamSuccess() {
        return this.undeployParamSuccess;
    }

    String getAppNameForUndeploy() {
        return this.appNameForUndeploy;
    }

    boolean isConnector() {
        return this.isConnector;
    }

    boolean isKeepFiles() {
        return this.keepFiles;
    }

    ByteArrayInputStream getDeploymentPlan(String appName, Map extraParams, SharedModuleType moduleType) {
        String tmp = "applicationID=" + appName + "\n";
        tmp = tmp + "moduleType=" + moduleType + "\n";
        if (extraParams != null) {
            Iterator it = extraParams.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)extraParams.get(key);
                tmp = tmp + key + "=" + value + "\n";
            }
        }
        return new ByteArrayInputStream(tmp.getBytes());
    }

    TargetModuleID[] getTargetModuleID(String deployName, boolean isConnector) {
        ObjectName name = isConnector ? ObjectNameFactory.create("oc4j:j2eeType=ResourceAdapterModule,name=" + deployName + ",J2EEApplication=default,J2EEServer=" + "standalone") : ObjectNameFactory.create("oc4j:j2eeType=J2EEApplication,name=" + deployName + ",J2EEServer=" + "standalone");
        TargetModuleIDImpl tid = new TargetModuleIDImpl(AdminShell.getManagement(), name);
        TargetModuleID[] result = new TargetModuleID[]{tid};
        return result;
    }

    TargetModuleIDImpl getTargetModuleID(String appName, String webModuleName) {
        ObjectName name = ObjectNameFactory.create("oc4j:j2eeType=WebModule,name=" + webModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + "standalone");
        TargetModuleIDImpl tid = new TargetModuleIDImpl(AdminShell.getManagement(), name);
        return tid;
    }

    TargetModuleIDImpl getTargetModuleID(String appName) {
        ObjectName name = ObjectNameFactory.create("oc4j:j2eeType=J2EEApplication,name=" + appName + ",J2EEServer=" + "standalone");
        TargetModuleIDImpl tid = new TargetModuleIDImpl(AdminShell.getManagement(), name);
        return tid;
    }
}

