/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressListener;
import oracle.oc4j.admin.deploy.shell.AdminShell;
import oracle.oc4j.admin.deploy.shell.DeployerImpl;
import oracle.oc4j.admin.deploy.shell.DeployerUtils;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.deploy.spi.status.DeployProgressListenerWriter;
import oracle.oc4j.admin.management.shared.SharedModuleType;

class EJBDeployer
extends DeployerImpl {
    EJBDeployer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDeployment(List arguments) throws DeploymentRuntimeException, IllegalArgumentException {
        DeployerUtils deployerUtils = new DeployerUtils();
        deployerUtils.processDeployParameters(arguments);
        if (!deployerUtils.isDeployParamSuccess()) {
            throw new IllegalArgumentException("Can not get deployment parameters correctly");
        }
        String fileName = deployerUtils.getFileName();
        String applicationName = deployerUtils.getAppNameForDeploy();
        Map extraParameters = deployerUtils.getExtraParameters();
        boolean force = deployerUtils.getForce();
        try {
            FileInputStream ejbStream = new FileInputStream(new File(fileName));
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            System.out.println("Module Type is " + extension);
            if (!extension.equalsIgnoreCase("jar")) {
                throw new IllegalArgumentException("The file associated with type " + extension + " can not be deployed by this command.");
            }
            ByteArrayInputStream bin = deployerUtils.getDeploymentPlan(applicationName, extraParameters, SharedModuleType.EAR);
            String deploymentMonitor = "ejbdeploymentMonitor";
            ProprietaryConnectedDeploymentManager pcDeplMgr = AdminShell.getProprietaryConnectedDeplManag();
            String string = deploymentMonitor;
            synchronized (string) {
                DeployProgressListenerWriter listener = new DeployProgressListenerWriter((OutputStream)System.out, (Object)deploymentMonitor);
                if (force) {
                    TargetModuleID[] tids = deployerUtils.getTargetModuleID(applicationName, false);
                    pcDeplMgr.redeploy(tids, ejbStream, (InputStream)bin, (ProgressListener)listener);
                } else {
                    pcDeplMgr.distribute(AdminShell.getDeploymentManager().getTargets(), ejbStream, (InputStream)bin, (ProgressListener)listener);
                }
                deploymentMonitor.wait();
            }
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException("Error deploying: " + e.getMessage());
        }
    }
}

