/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.factories;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.spi.ClusterDeploymentManager;
import oracle.oc4j.admin.deploy.spi.factories.DeploymentFactoryBase;

public class ClusterDeploymentFactory
extends DeploymentFactoryBase {
    private static Logger logger_ = TraceLogger.getLogger((Class)ClusterDeploymentFactory.class);

    public final boolean handlesURI(String uri) {
        if (super.handlesURI(uri)) {
            StringTokenizer strTok = new StringTokenizer(uri, ":");
            strTok.nextToken();
            if (strTok.hasMoreTokens() && "cluster".equalsIgnoreCase(strTok.nextToken())) {
                return true;
            }
        }
        return false;
    }

    public final String getDisplayName() {
        return "Oracle's J2EE deployment factory for clustered OC4Js";
    }

    public final DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        try {
            if (!this.handlesURI(uri)) {
                throw new DeploymentManagerCreationException("This deployment factory cannot handle uri: " + uri);
            }
            if (username == null || password == null) {
                throw new DeploymentManagerCreationException("username and password must be specified");
            }
            String opmnHost = null;
            int opmnPort = 6003;
            String oc4jInstance = null;
            String protocolProperty = null;
            StringTokenizer strTok = new StringTokenizer(uri, ":");
            if (strTok.countTokens() < 3) {
                throw new DeploymentManagerCreationException("Invalid deployer url: " + uri);
            }
            strTok.nextToken();
            strTok.nextToken();
            opmnHost = strTok.nextToken();
            if ("rmis".equalsIgnoreCase(opmnHost) || "ormis".equalsIgnoreCase(opmnHost)) {
                protocolProperty = "ormis";
                opmnHost = strTok.nextToken();
            }
            if ("rmi".equalsIgnoreCase(opmnHost) || "ormi".equalsIgnoreCase(opmnHost)) {
                opmnHost = strTok.nextToken();
            }
            if (!"opmn".equalsIgnoreCase(opmnHost)) {
                throw new DeploymentManagerCreationException("Invalid deployer url: " + uri);
            }
            opmnHost = strTok.nextToken();
            if (opmnHost == null || opmnHost.length() < 2) {
                throw new DeploymentManagerCreationException("Invalid URL: " + uri);
            }
            opmnHost = opmnHost.substring(2);
            if (strTok.countTokens() > 0) {
                String portAndInstance = strTok.nextToken();
                StringTokenizer strTokb = new StringTokenizer(portAndInstance, "/");
                opmnPort = Integer.parseInt(strTokb.nextToken());
                oc4jInstance = strTokb.nextToken();
            } else {
                StringTokenizer strTokb = new StringTokenizer(opmnHost, "/");
                opmnHost = strTokb.nextToken();
                oc4jInstance = strTokb.nextToken();
            }
            if (opmnHost == null || opmnHost.length() == 0) {
                throw new DeploymentManagerCreationException("Missing host parameter in URL: " + uri);
            }
            if (oc4jInstance == null || oc4jInstance.length() == 0) {
                throw new DeploymentManagerCreationException("Missing OC4J instance parameter in URL: " + uri);
            }
            return new ClusterDeploymentManager(uri, username, password);
        }
        catch (DeploymentManagerCreationException de) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, de.getMessage(), de);
            }
            throw de;
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException(t.getMessage());
            dmce.initCause(t);
            throw dmce;
        }
    }
}

