/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.model.xml.ApplicationBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ApplicationConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.ClusterTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClusterType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportedLibrariesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportedLibrariesType;
import oracle.oc4j.admin.deploy.spi.xml.JaznConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.JaznLoginConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznLoginConfigType;
import oracle.oc4j.admin.deploy.spi.xml.JaznTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JmxMBeansTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LibrariesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LogTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LogType;
import oracle.oc4j.admin.deploy.spi.xml.MailSessionsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceAccessTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceAccessType;
import oracle.oc4j.admin.deploy.spi.xml.PropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ResourceProvidersTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.UserManagerConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.UserManagerTreeNode;

public class ApplicationMappingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ApplicationConfigBean _bean;
    private static final String ADD_LOG_MENU_STRING = "Add Log";
    private static final String ADD_NAMESPACE_ACCESS_MENU_STRING = "Add Namespace Access";
    private static final String ADD_JAZN_MENU_STRING = "Add Jazn";
    private static final String ADD_USER_MANAGER_MENU_STRING = "Add User Manager";
    private static final String ADD_IMPORTED_LIBRARIES_MENU_STRING = "Add Imported Shared Libraries";
    private static final String ADD_CLUSTER_MENU_STRING = "Add Cluster";
    private static final String ADD_JAZN_LOGIN_CONFIG_MENU_STRING = "Add Jazn Login Config";
    private JMenuItem _addLogMenuItem;
    private JMenuItem _addNamespaceAccessMenuItem;
    private JMenuItem _addJaznMenuItem;
    private JMenuItem _addUserManagerMenuItem;
    private JMenuItem _addImportedLibrariesMenuItem;
    private JMenuItem _addClusterMenuItem;
    private JMenuItem _addJaznLoginConfigMenuItem;

    public ApplicationMappingsTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (ApplicationConfigBean)bean;
        this._addClusterMenuItem = new JMenuItem(ADD_CLUSTER_MENU_STRING);
        this._addClusterMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addClusterMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addClusterMenuItem.addActionListener(this);
        if (this._bean.getCluster() != null) {
            this._addClusterMenuItem.setEnabled(false);
        }
        this._addJaznMenuItem = new JMenuItem(ADD_JAZN_MENU_STRING);
        this._addJaznMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJaznMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addJaznMenuItem.addActionListener(this);
        if (this._bean.getJazn() != null) {
            this._addJaznMenuItem.setEnabled(false);
        }
        this._addLogMenuItem = new JMenuItem(ADD_LOG_MENU_STRING);
        this._addLogMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addLogMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addLogMenuItem.addActionListener(this);
        if (this._bean.getLog() != null) {
            this._addLogMenuItem.setEnabled(false);
        }
        this._addNamespaceAccessMenuItem = new JMenuItem(ADD_NAMESPACE_ACCESS_MENU_STRING);
        this._addNamespaceAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addNamespaceAccessMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addNamespaceAccessMenuItem.addActionListener(this);
        if (this._bean.getNamespaceAccess() != null) {
            this._addNamespaceAccessMenuItem.setEnabled(false);
        }
        this._addUserManagerMenuItem = new JMenuItem(ADD_USER_MANAGER_MENU_STRING);
        this._addUserManagerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addUserManagerMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addUserManagerMenuItem.addActionListener(this);
        if (this._bean.getUserManagerByClass() != null) {
            this._addUserManagerMenuItem.setEnabled(false);
        }
        this._addImportedLibrariesMenuItem = new JMenuItem(ADD_IMPORTED_LIBRARIES_MENU_STRING);
        this._addImportedLibrariesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addImportedLibrariesMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addImportedLibrariesMenuItem.addActionListener(this);
        if (this._bean.getImportedLibraries() != null) {
            this._addImportedLibrariesMenuItem.setEnabled(false);
        }
        this._addJaznLoginConfigMenuItem = new JMenuItem(ADD_JAZN_LOGIN_CONFIG_MENU_STRING);
        this._addJaznLoginConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJaznLoginConfigMenuItem.setFont(ApplicationMappingsTreeNode.getFont());
        this._addJaznLoginConfigMenuItem.addActionListener(this);
        if (this._bean.getJaznLoginConfig() != null) {
            this._addJaznLoginConfigMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addClusterMenuItem);
        this._popup.add(this._addJaznMenuItem);
        this._popup.add(this._addLogMenuItem);
        this._popup.add(this._addNamespaceAccessMenuItem);
        this._popup.add(this._addUserManagerMenuItem);
        this._popup.add(this._addImportedLibrariesMenuItem);
        this._popup.add(this._addJaznLoginConfigMenuItem);
    }

    public String viewHeaderString() {
        return "Application Mappings";
    }

    public String toString() {
        return ((ApplicationBean)this._bean.getDDBean()).getDisplayName();
    }

    protected void buildChildJTree() {
        ImportedLibrariesType importedLibraries;
        Method xmlMethod;
        JaznConfigBean jazn;
        ClusterType cluster = this._bean.getCluster();
        if (cluster != null) {
            ClusterTreeNode clusterTreeNode = new ClusterTreeNode(this.getRootNode(), cluster);
            this.addChild(clusterTreeNode);
        }
        if ((jazn = this._bean.getJazn()) != null) {
            JaznTreeNode jaznTreeNode = new JaznTreeNode(this.getRootNode(), jazn);
            this.addChild(jaznTreeNode);
        }
        try {
            Method xmlMethod2 = ApplicationConfigBean.class.getMethod("writeLibrariesXML", PrintWriter.class, String.class);
            LibrariesTreeNode librariesTreeNode = new LibrariesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod2));
            this.addChild(librariesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        LogType log = this._bean.getLog();
        if (log != null) {
            LogTreeNode logTreeNode = new LogTreeNode(this.getRootNode(), log);
            this.addChild(logTreeNode);
        }
        try {
            Method xmlMethod3 = ApplicationConfigBean.class.getMethod("writeMailSessionsXML", PrintWriter.class, String.class);
            MailSessionsTreeNode mailSessionsTreeNode = new MailSessionsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod3));
            this.addChild(mailSessionsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        NamespaceAccessType namespaceAccess = this._bean.getNamespaceAccess();
        if (namespaceAccess != null) {
            NamespaceAccessTreeNode namespaceAccessTreeNode = new NamespaceAccessTreeNode(this.getRootNode(), namespaceAccess);
            this.addChild(namespaceAccessTreeNode);
        }
        try {
            xmlMethod = ApplicationConfigBean.class.getMethod("writePropertiesXML", PrintWriter.class, String.class);
            PropertiesTreeNode propertiesTreeNode = new PropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(propertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod = ApplicationConfigBean.class.getMethod("writeResourceProvidersXML", PrintWriter.class, String.class);
            ResourceProvidersTreeNode resourceProvidersTreeNode = new ResourceProvidersTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(resourceProvidersTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        UserManagerConfigBean userManager = this._bean.getUserManagerByClass();
        if (userManager != null) {
            UserManagerTreeNode userManagerTreeNode = new UserManagerTreeNode(this.getRootNode(), userManager);
            this.addChild(userManagerTreeNode);
        }
        if ((importedLibraries = this._bean.getImportedLibraries()) != null) {
            ImportedLibrariesTreeNode importedLibrariesTreeNode = new ImportedLibrariesTreeNode(this.getRootNode(), importedLibraries);
            this.addChild(importedLibrariesTreeNode);
        }
        try {
            Method xmlMethod4 = ApplicationConfigBean.class.getMethod("writeJmxMBeansXML", PrintWriter.class, String.class);
            JmxMBeansTreeNode jmxMBeansTreeNode = new JmxMBeansTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod4));
            this.addChild(jmxMBeansTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        JaznLoginConfigType jaznLoginConfig = this._bean.getJaznLoginConfig();
        if (jaznLoginConfig != null) {
            JaznLoginConfigTreeNode jaznLoginConfigTreeNode = new JaznLoginConfigTreeNode(this.getRootNode(), jaznLoginConfig);
            this.addChild(jaznLoginConfigTreeNode);
        }
    }

    public boolean showDefaults() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_CLUSTER_MENU_STRING)) {
                ClusterType newCluster;
                if (this._bean.getCluster() == null && this.showAddDialog(newCluster = this._bean.defaultCluster(), ADD_CLUSTER_MENU_STRING)) {
                    this._bean.setCluster(newCluster);
                    ClusterTreeNode newNode = new ClusterTreeNode(this, newCluster);
                    this.insertNode(newNode);
                    this._addClusterMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_JAZN_MENU_STRING)) {
                JaznConfigBean newJazn;
                if (this._bean.getJazn() == null && this.showAddDialog(newJazn = this._bean.defaultJazn(), ADD_JAZN_MENU_STRING)) {
                    this._bean.setJazn(newJazn);
                    JaznTreeNode newNode = new JaznTreeNode(this, newJazn);
                    this.insertNode(newNode);
                    this._addJaznMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_LOG_MENU_STRING)) {
                if (this._bean.getLog() == null) {
                    this._bean.addLog();
                    LogTreeNode newNode = new LogTreeNode(this, this._bean.getLog());
                    this.insertNode(newNode);
                    this._addLogMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_NAMESPACE_ACCESS_MENU_STRING)) {
                if (this._bean.getNamespaceAccess() == null) {
                    this._bean.addNamespaceAccess();
                    NamespaceAccessTreeNode newNode = new NamespaceAccessTreeNode(this, this._bean.getNamespaceAccess());
                    this.insertNode(newNode);
                    this._addNamespaceAccessMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_USER_MANAGER_MENU_STRING)) {
                UserManagerConfigBean newUserManager;
                if (this._bean.getUserManagerByClass() == null && this.showAddDialog(newUserManager = this._bean.defaultUserManagerByClass(), ADD_USER_MANAGER_MENU_STRING)) {
                    this._bean.setUserManagerByClass(newUserManager);
                    UserManagerTreeNode newNode = new UserManagerTreeNode(this, newUserManager);
                    this.insertNode(newNode);
                    this._addUserManagerMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_IMPORTED_LIBRARIES_MENU_STRING)) {
                if (this._bean.getImportedLibraries() == null) {
                    this._bean.addImportedLibraries();
                    ImportedLibrariesTreeNode newNode = new ImportedLibrariesTreeNode(this, this._bean.getImportedLibraries());
                    this.insertNode(newNode);
                    this._addImportedLibrariesMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_JAZN_LOGIN_CONFIG_MENU_STRING) && this._bean.getJaznLoginConfig() == null) {
                this._bean.addJaznLoginConfig();
                JaznLoginConfigTreeNode newNode = new JaznLoginConfigTreeNode(this, this._bean.getJaznLoginConfig());
                this.insertNode(newNode);
                this._addJaznLoginConfigMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ClusterTreeNode) {
            this._bean.removeCluster();
            this.removeNode(node);
            this._addClusterMenuItem.setEnabled(true);
        } else if (node instanceof JaznTreeNode) {
            this._bean.removeJazn();
            this.removeNode(node);
            this._addJaznMenuItem.setEnabled(true);
        } else if (node instanceof LogTreeNode) {
            this._bean.removeLog();
            this.removeNode(node);
            this._addLogMenuItem.setEnabled(true);
        } else if (node instanceof NamespaceAccessTreeNode) {
            this._bean.removeNamespaceAccess();
            this.removeNode(node);
            this._addNamespaceAccessMenuItem.setEnabled(true);
        } else if (node instanceof UserManagerTreeNode) {
            this._bean.removeUserManagerByClass();
            this.removeNode(node);
            this._addUserManagerMenuItem.setEnabled(true);
        } else if (node instanceof ImportedLibrariesTreeNode) {
            this._bean.removeImportedLibraries();
            this.removeNode(node);
            this._addImportedLibrariesMenuItem.setEnabled(true);
        } else if (node instanceof JaznLoginConfigTreeNode) {
            this._bean.removeJaznLoginConfig();
            this.removeNode(node);
            this._addJaznLoginConfigMenuItem.setEnabled(true);
        }
    }
}

