/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ArgumentTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ArgumentType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class ArgumentsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_ARGUMENT_MENU_STRING = "Add Argument";
    private JMenuItem _addArgumentMenuItem;
    private ArgumentType[] argumentsType = new ArgumentType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ArgumentsTreeNode(ConfigTreeNode rootNode, MultipleType arguments) {
        super(arguments);
        this.setRootNode(rootNode);
        this._parentBean = arguments.getConfigParent();
        this._addArgumentMenuItem = new JMenuItem(ADD_ARGUMENT_MENU_STRING);
        this._addArgumentMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addArgumentMenuItem.setFont(ArgumentsTreeNode.getFont());
        this._addArgumentMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addArgumentMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getArguments", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addArgument", ArgumentType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeArgument", ArgumentType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Arguments";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ArgumentType[] arguments = (ArgumentType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    ArgumentType argument = arguments[i];
                    if (argument == null) continue;
                    ArgumentTreeNode argumentTreeNode = new ArgumentTreeNode(this.getRootNode(), argument);
                    this.addChild(argumentTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ArgumentType newArgument;
            if (event.getActionCommand().equals(ADD_ARGUMENT_MENU_STRING) && this.showAddDialog(newArgument = new ArgumentType(this._parentBean), ADD_ARGUMENT_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newArgument);
                ArgumentTreeNode newNode = new ArgumentTreeNode(this, newArgument);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ArgumentTreeNode) {
            try {
                ArgumentType argument = (ArgumentType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, argument);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

