/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AsContextType
extends ConfigBeanNode {
    StringType _authMethod = null;
    StringType _oldAuthMethod = null;
    String _realm = null;
    BooleanType _required = null;
    BooleanType _oldRequired = null;

    public AsContextType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public AsContextType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setAuthMethod(StringType authMethod) throws ConfigurationException {
        this._authMethod = authMethod;
        this.firePropertyChange("authMethod", this._oldAuthMethod, this._authMethod);
        if (this._authMethod != null) {
            if (this._oldAuthMethod == null) {
                this._oldAuthMethod = this.defaultAuthMethod();
            }
            this._oldAuthMethod.setValue(this._authMethod.getValue());
        } else {
            this._oldAuthMethod = null;
        }
    }

    public StringType getAuthMethod() {
        return this._authMethod;
    }

    public StringType defaultAuthMethod() {
        String[] tags = new String[]{"none", "username_password"};
        return new StringType(this, tags, "username_password");
    }

    public void setRealm(String realm) throws ConfigurationException {
        String oldValue = this._realm;
        this._realm = realm;
        this.firePropertyChange("realm", oldValue, this._realm);
    }

    public String getRealm() {
        return this._realm;
    }

    public String defaultRealm() {
        return "default";
    }

    public void setRequired(BooleanType required) throws ConfigurationException {
        this._required = required;
        this.firePropertyChange("required", this._oldRequired, this._required);
        if (this._required != null) {
            if (this._oldRequired == null) {
                this._oldRequired = this.defaultRequired();
            }
            this._oldRequired.setValue(this._required.getValue());
        } else {
            this._oldRequired = null;
        }
    }

    public BooleanType getRequired() {
        return this._required;
    }

    public BooleanType defaultRequired() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "as-context");
        XMLUtils.writeTagAttributeEnd(out, indentation, "as-context");
        if (this._authMethod != null && this._authMethod.getValue() != null && this._authMethod.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "auth-method", this._authMethod);
        }
        if (this._realm != null && this._realm.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "realm", this._realm);
        }
        if (this._required != null && this._required.getValue() != null) {
            XMLUtils.writeTag(out, indentation + "\t", "required", this._required);
        }
        XMLUtils.writeTagEnd(out, indentation, "as-context");
    }

    private void init() throws ConfigurationException {
        this.setXpath("as-context");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("auth-method")) {
                    StringType authMethod = this.defaultAuthMethod();
                    authMethod.setValue(XMLUtils.getValue(node));
                    this.setAuthMethod(authMethod);
                    continue;
                }
                if (name.equals("realm")) {
                    this.setRealm(XMLUtils.getValue(node));
                    continue;
                }
                if (!name.equals("required")) continue;
                BooleanType required = this.defaultRequired();
                required.setValue(XMLUtils.getValue(node));
                this.setRequired(required);
            }
        }
    }
}

