/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ClientPortRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OwsmTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OwsmType;
import oracle.oc4j.admin.deploy.spi.xml.ReliabilityClientTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ReliabilityClientType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigPortTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigPortType;

public class ClientPortRuntimeTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ClientPortRuntimeType _bean;
    private static final String ADD_OWSM_MENU_STRING = "Add Owsm";
    private static final String ADD_SECURITY_MENU_STRING = "Add Security";
    private static final String ADD_RELIABILITY_MENU_STRING = "Add Reliability";
    private static final String REMOVE_RUNTIME_MENU_STRING = "Remove Runtime";
    private JMenuItem _addOwsmMenuItem;
    private JMenuItem _addSecurityMenuItem;
    private JMenuItem _addReliabilityMenuItem;
    private JMenuItem _removeRuntimeMenuItem;

    public ClientPortRuntimeTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (ClientPortRuntimeType)bean;
        this._addOwsmMenuItem = new JMenuItem(ADD_OWSM_MENU_STRING);
        this._addOwsmMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOwsmMenuItem.setFont(ClientPortRuntimeTreeNode.getFont());
        this._addOwsmMenuItem.addActionListener(this);
        if (this._bean.getOwsm() != null) {
            this._addOwsmMenuItem.setEnabled(false);
        }
        this._addSecurityMenuItem = new JMenuItem(ADD_SECURITY_MENU_STRING);
        this._addSecurityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSecurityMenuItem.setFont(ClientPortRuntimeTreeNode.getFont());
        this._addSecurityMenuItem.addActionListener(this);
        if (this._bean.getSecurity() != null) {
            this._addSecurityMenuItem.setEnabled(false);
        }
        this._addReliabilityMenuItem = new JMenuItem(ADD_RELIABILITY_MENU_STRING);
        this._addReliabilityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addReliabilityMenuItem.setFont(ClientPortRuntimeTreeNode.getFont());
        this._addReliabilityMenuItem.addActionListener(this);
        if (this._bean.getReliability() != null) {
            this._addReliabilityMenuItem.setEnabled(false);
        }
        this._removeRuntimeMenuItem = new JMenuItem(REMOVE_RUNTIME_MENU_STRING);
        this._removeRuntimeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeRuntimeMenuItem.setFont(ClientPortRuntimeTreeNode.getFont());
        this._removeRuntimeMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addOwsmMenuItem);
        this._popup.add(this._addSecurityMenuItem);
        this._popup.add(this._addReliabilityMenuItem);
        this._popup.add(this._removeRuntimeMenuItem);
    }

    public String viewHeaderString() {
        return "Runtime";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            OwsmType owsm = this._bean.getOwsm();
            if (owsm != null) {
                OwsmTreeNode owsmTreeNode = new OwsmTreeNode(this.getRootNode(), owsm);
                this.addChild(owsmTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            SecurityConfigPortType security = this._bean.getSecurity();
            if (security != null) {
                SecurityConfigPortTreeNode securityConfigPortTreeNode = new SecurityConfigPortTreeNode(this.getRootNode(), security);
                this.addChild(securityConfigPortTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            ReliabilityClientType reliability = this._bean.getReliability();
            if (reliability != null) {
                ReliabilityClientTreeNode reliabilityClientTreeNode = new ReliabilityClientTreeNode(this.getRootNode(), reliability);
                this.addChild(reliabilityClientTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_OWSM_MENU_STRING)) {
                OwsmType newOwsm;
                if (this._bean.getOwsm() == null && this.showAddDialog(newOwsm = this._bean.defaultOwsm(), ADD_OWSM_MENU_STRING)) {
                    this._bean.setOwsm(newOwsm);
                    OwsmTreeNode newNode = new OwsmTreeNode(this, newOwsm);
                    this.insertNode(newNode);
                    this._addOwsmMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SECURITY_MENU_STRING)) {
                if (this._bean.getSecurity() == null) {
                    this._bean.addSecurity();
                    SecurityConfigPortTreeNode newNode = new SecurityConfigPortTreeNode(this, this._bean.getSecurity());
                    this.insertNode(newNode);
                    this._addSecurityMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_RELIABILITY_MENU_STRING)) {
                ReliabilityClientType newReliability;
                if (this._bean.getReliability() == null && this.showAddDialog(newReliability = this._bean.defaultReliability(), ADD_RELIABILITY_MENU_STRING)) {
                    this._bean.setReliability(newReliability);
                    ReliabilityClientTreeNode newNode = new ReliabilityClientTreeNode(this, newReliability);
                    this.insertNode(newNode);
                    this._addReliabilityMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_RUNTIME_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof OwsmTreeNode) {
            this._bean.removeOwsm();
            this.removeNode(node);
            this._addOwsmMenuItem.setEnabled(true);
        } else if (node instanceof SecurityConfigPortTreeNode) {
            this._bean.removeSecurity();
            this.removeNode(node);
            this._addSecurityMenuItem.setEnabled(true);
        } else if (node instanceof ReliabilityClientTreeNode) {
            this._bean.removeReliability();
            this.removeNode(node);
            this._addReliabilityMenuItem.setEnabled(true);
        }
    }
}

