/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.DefaultMethodAccessType;
import oracle.oc4j.admin.deploy.spi.xml.EjbModuleMappingsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EntityDeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.MessageDestinationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.MessageDrivenDeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PersistenceManagerType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.SessionDeploymentConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EjbModuleConfigBean
extends ConfigBeanNode {
    protected String _deploymentVersion = null;
    protected DefaultMethodAccessType _defaultMethodAccess = null;
    protected PersistenceManagerType _persistenceManager = null;

    public EjbModuleConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public EjbModuleConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setDeploymentVersion(String deploymentVersion) throws ConfigurationException {
        String oldValue = this._deploymentVersion;
        this._deploymentVersion = deploymentVersion;
        this.firePropertyChange("deploymentVersion", oldValue, this._deploymentVersion);
    }

    public String getDeploymentVersion() {
        return this._deploymentVersion;
    }

    public String defaultDeploymentVersion() {
        return "";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "orion-ejb-jar");
        XMLUtils.writeAttribute(out, indentation, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUtils.writeAttribute(out, indentation, "xsi:noNamespaceSchemaLocation", "http://xmlns.oracle.com/oracleas/schema/orion-ejb-jar-10_0.xsd");
        XMLUtils.writeAttribute(out, indentation, "deployment-version", this._deploymentVersion);
        XMLUtils.writeTagAttributeEnd(out, indentation, "orion-ejb-jar");
        XMLUtils.writeTagStart(out, indentation + "\t", "enterprise-beans");
        if (this.getPersistenceManager() != null) {
            this.getPersistenceManager().writeXML(out, indentation + "\t\t");
        }
        EjbModuleConfigBean.writeAll(this.getChildBean("enterprise-beans/session-deployment"), out, indentation + "\t" + "\t");
        EjbModuleConfigBean.writeAll(this.getChildBean("enterprise-beans/entity-deployment"), out, indentation + "\t" + "\t");
        EjbModuleConfigBean.writeAll(this.getChildBean("enterprise-beans/message-driven-deployment"), out, indentation + "\t" + "\t");
        XMLUtils.writeTagEnd(out, indentation + "\t", "enterprise-beans");
        XMLUtils.writeTagStart(out, indentation + "\t", "assembly-descriptor");
        EjbModuleConfigBean.writeAll(this.getChildBean("assembly-descriptor/security-role-mapping"), out, indentation + "\t" + "\t");
        EjbModuleConfigBean.writeAll(this.getChildBean("assembly-descriptor/message-destination-mapping"), out, indentation + "\t\t");
        if (this.getDefaultMethodAccess() != null) {
            this.getDefaultMethodAccess().writeXML(out, indentation + "\t\t");
        }
        XMLUtils.writeTagEnd(out, indentation + "\t", "assembly-descriptor");
        XMLUtils.writeTagEnd(out, indentation, "orion-ejb-jar");
    }

    private void init() throws ConfigurationException {
        this.setXpath("orion-ejb-jar");
        this._xpaths = new String[5];
        this._xpaths[0] = "assembly-descriptor/security-role";
        this._xpaths[1] = "assembly-descriptor/message-destination";
        this._xpaths[2] = "enterprise-beans/session";
        this._xpaths[3] = "enterprise-beans/entity";
        this._xpaths[4] = "enterprise-beans/message-driven";
        this._configXpaths = new String[5];
        this._configXpaths[0] = "assembly-descriptor/security-role-mapping";
        this._configXpaths[1] = "assembly-descriptor/message-destination-mapping";
        this._configXpaths[2] = "enterprise-beans/session-deployment";
        this._configXpaths[3] = "enterprise-beans/entity-deployment";
        this._configXpaths[4] = "enterprise-beans/message-driven-deployment";
        Vector<SecurityRoleMappingConfigBean> securityMaps = new Vector<SecurityRoleMappingConfigBean>();
        Vector<SecurityRoleMappingConfigBean> sessionBeans = new Vector<SecurityRoleMappingConfigBean>();
        Vector<SecurityRoleMappingConfigBean> entityBeans = new Vector<SecurityRoleMappingConfigBean>();
        Vector<SecurityRoleMappingConfigBean> messageDrivenBeans = new Vector<SecurityRoleMappingConfigBean>();
        Vector<SecurityRoleMappingConfigBean> messageDestinationMaps = new Vector<SecurityRoleMappingConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "deployment-version");
            if (val != null && !val.trim().equals("")) {
                this.setDeploymentVersion(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ConfigBeanNode configBean;
                int a;
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("assembly-descriptor")) {
                    NodeList assemblyNodes = node.getChildNodes();
                    for (a = 0; a < assemblyNodes.getLength(); ++a) {
                        node = assemblyNodes.item(a);
                        name = node.getNodeName();
                        if (name.equals("security-role-mapping")) {
                            configBean = new SecurityRoleMappingConfigBean(this, node);
                            securityMaps.add((SecurityRoleMappingConfigBean)configBean);
                            continue;
                        }
                        if (name.equals("message-destination-mapping")) {
                            configBean = new MessageDestinationMappingType(this, node);
                            messageDestinationMaps.add((SecurityRoleMappingConfigBean)configBean);
                            continue;
                        }
                        if (!name.equals("default-method-access")) continue;
                        this.setDefaultMethodAccess(new DefaultMethodAccessType(this, node));
                    }
                }
                if (!name.equals("enterprise-beans")) continue;
                NodeList beansNodes = node.getChildNodes();
                for (a = 0; a < beansNodes.getLength(); ++a) {
                    node = beansNodes.item(a);
                    name = node.getNodeName();
                    if (name.equals("session-deployment")) {
                        configBean = new SessionDeploymentConfigBean(this, node);
                        sessionBeans.add((SecurityRoleMappingConfigBean)configBean);
                        continue;
                    }
                    if (name.equals("entity-deployment")) {
                        configBean = new EntityDeploymentConfigBean(this, node);
                        entityBeans.add((SecurityRoleMappingConfigBean)configBean);
                        continue;
                    }
                    if (name.equals("message-driven-deployment")) {
                        configBean = new MessageDrivenDeploymentConfigBean(this, node);
                        messageDrivenBeans.add((SecurityRoleMappingConfigBean)configBean);
                        continue;
                    }
                    if (!name.equals("persistence-manager")) continue;
                    this.setPersistenceManager(new PersistenceManagerType(this, node));
                }
            }
        }
        this.recordXpathForBeans("assembly-descriptor/security-role-mapping", securityMaps);
        this.recordXpathForBeans("assembly-descriptor/message-destination-mapping", messageDestinationMaps);
        this.recordXpathForBeans("enterprise-beans/session-deployment", sessionBeans);
        this.recordXpathForBeans("enterprise-beans/entity-deployment", entityBeans);
        this.recordXpathForBeans("enterprise-beans/message-driven-deployment", messageDrivenBeans);
    }

    public ViewableJTree[] subTrees() {
        EjbModuleMappingsTreeNode treeNode = new EjbModuleMappingsTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public void setDefaultMethodAccess(DefaultMethodAccessType defaultMethodAccess) throws ConfigurationException {
        DefaultMethodAccessType oldValue = this._defaultMethodAccess;
        this._defaultMethodAccess = defaultMethodAccess;
        this.firePropertyChange("defaultMethodAccess", oldValue, this._defaultMethodAccess);
    }

    public DefaultMethodAccessType getDefaultMethodAccess() {
        return this._defaultMethodAccess;
    }

    public DefaultMethodAccessType defaultDefaultMethodAccess() {
        try {
            return new DefaultMethodAccessType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addDefaultMethodAccess() throws ConfigurationException {
        if (this._defaultMethodAccess != null) {
            return;
        }
        DefaultMethodAccessType defaultMethodAccess = new DefaultMethodAccessType(this, null);
        this.setDefaultMethodAccess(defaultMethodAccess);
    }

    public void removeDefaultMethodAccess() throws ConfigurationException {
        if (this._defaultMethodAccess == null) {
            return;
        }
        this.setDefaultMethodAccess(null);
    }

    public void setPersistenceManager(PersistenceManagerType persistenceManager) throws ConfigurationException {
        PersistenceManagerType oldValue = this._persistenceManager;
        this._persistenceManager = persistenceManager;
        this.firePropertyChange("persistenceManager", oldValue, this._persistenceManager);
    }

    public PersistenceManagerType getPersistenceManager() {
        return this._persistenceManager;
    }

    public PersistenceManagerType defaultPersistenceManager() {
        try {
            return new PersistenceManagerType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addPersistenceManager() throws ConfigurationException {
        if (this._persistenceManager != null) {
            return;
        }
        PersistenceManagerType persistenceManager = new PersistenceManagerType(this, null);
        this.setPersistenceManager(persistenceManager);
    }

    public void removePersistenceManager() throws ConfigurationException {
        if (this._persistenceManager == null) {
            return;
        }
        this.setPersistenceManager(null);
    }
}

