/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.model.xml.EjbModuleBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DefaultMethodAccessTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DefaultMethodAccessType;
import oracle.oc4j.admin.deploy.spi.xml.EjbModuleConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PersistenceManagerTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PersistenceManagerType;

public class EjbModuleMappingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private EjbModuleConfigBean _bean;
    private static final String ADD_DEFAULT_METHOD_ACCESS_MENU_STRING = "Add Default Method Access";
    private JMenuItem _addDefaultMethodAccessMenuItem;
    private static final String ADD_PERSISTENCE_MANAGER_MENU_STRING = "Add Persistence Manager";
    private JMenuItem _addPersistenceManagerMenuItem;

    public EjbModuleMappingsTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (EjbModuleConfigBean)bean;
        this._addDefaultMethodAccessMenuItem = new JMenuItem(ADD_DEFAULT_METHOD_ACCESS_MENU_STRING);
        this._addDefaultMethodAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addDefaultMethodAccessMenuItem.setFont(EjbModuleMappingsTreeNode.getFont());
        this._addDefaultMethodAccessMenuItem.addActionListener(this);
        if (this._bean.getDefaultMethodAccess() != null) {
            this._addDefaultMethodAccessMenuItem.setEnabled(false);
        }
        this._addPersistenceManagerMenuItem = new JMenuItem(ADD_PERSISTENCE_MANAGER_MENU_STRING);
        this._addPersistenceManagerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPersistenceManagerMenuItem.setFont(EjbModuleMappingsTreeNode.getFont());
        this._addPersistenceManagerMenuItem.addActionListener(this);
        if (this._bean.getPersistenceManager() != null) {
            this._addPersistenceManagerMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addDefaultMethodAccessMenuItem);
        this._popup.add(this._addPersistenceManagerMenuItem);
    }

    public String viewHeaderString() {
        return "Ejb Module Mappings";
    }

    public String toString() {
        return ((EjbModuleBean)this._bean.getDDBean()).getDisplayName();
    }

    protected void buildChildJTree() {
        PersistenceManagerType persistenceManager;
        DefaultMethodAccessType defaultMethodAccess = this._bean.getDefaultMethodAccess();
        if (defaultMethodAccess != null) {
            DefaultMethodAccessTreeNode defaultMethodAccessTreeNode = new DefaultMethodAccessTreeNode(this.getRootNode(), defaultMethodAccess);
            this.addChild(defaultMethodAccessTreeNode);
        }
        if ((persistenceManager = this._bean.getPersistenceManager()) != null) {
            PersistenceManagerTreeNode persistenceManagerTreeNode = new PersistenceManagerTreeNode(this.getRootNode(), persistenceManager);
            this.addChild(persistenceManagerTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        ConfigTreeNode newNode;
        try {
            DefaultMethodAccessType newDefaultMethodAccess;
            if (event.getActionCommand().equals(ADD_DEFAULT_METHOD_ACCESS_MENU_STRING) && this.showAddDialog(newDefaultMethodAccess = this._bean.defaultDefaultMethodAccess(), ADD_DEFAULT_METHOD_ACCESS_MENU_STRING)) {
                this._bean.setDefaultMethodAccess(newDefaultMethodAccess);
                newNode = new DefaultMethodAccessTreeNode(this, newDefaultMethodAccess);
                this.insertNode(newNode);
                this._addDefaultMethodAccessMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            PersistenceManagerType newPersistenceManager;
            if (event.getActionCommand().equals(ADD_PERSISTENCE_MANAGER_MENU_STRING) && this.showAddDialog(newPersistenceManager = this._bean.defaultPersistenceManager(), ADD_PERSISTENCE_MANAGER_MENU_STRING)) {
                this._bean.setPersistenceManager(newPersistenceManager);
                newNode = new PersistenceManagerTreeNode(this, newPersistenceManager);
                this.insertNode(newNode);
                this._addPersistenceManagerMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof DefaultMethodAccessTreeNode) {
            this._bean.removeDefaultMethodAccess();
            this.removeNode(node);
            this._addDefaultMethodAccessMenuItem.setEnabled(true);
        }
        if (node instanceof PersistenceManagerTreeNode) {
            this._bean.removePersistenceManager();
            this.removeNode(node);
            this._addPersistenceManagerMenuItem.setEnabled(true);
        }
    }
}

