/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.EjbRefMappingTreeNode;
import org.w3c.dom.Node;

public class EjbRefMappingConfigBean
extends ConfigBeanNode {
    String _name = null;
    String _location = null;
    boolean _remoteServerRef = false;
    String _jndiPropertiesFile = null;

    public EjbRefMappingConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) {
        super(stdBean, parent, node);
        this.init();
    }

    public EjbRefMappingConfigBean(ConfigBeanNode parent, Node node) {
        this(null, parent, node);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        if (this._name != null) {
            return this._name;
        }
        return "";
    }

    public String key() {
        return this.getName();
    }

    public String beanKey() {
        return "ejb-ref-name";
    }

    public void setLocation(String location) throws ConfigurationException {
        String oldValue = this._location;
        this._location = location;
        this.firePropertyChange("location", oldValue, this._location);
    }

    public String getLocation() {
        return this._location;
    }

    public String defaultLocation() {
        return "";
    }

    public boolean getRemoteServerRef() {
        return this._remoteServerRef;
    }

    public void setRemoteServerRef(boolean remoteServerRef) {
        this._remoteServerRef = remoteServerRef;
    }

    public String getJndiPropertiesFile() {
        return this._jndiPropertiesFile;
    }

    public void setJndiPropertiesFile(String jndiPropertiesFile) {
        this._jndiPropertiesFile = jndiPropertiesFile;
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("location") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._location != null && this._location.length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation, "ejb-ref-mapping");
            XMLUtils.writeAttribute(out, indentation, "name", this._name);
            XMLUtils.writeAttribute(out, indentation, "location", this._location);
            if (this._remoteServerRef) {
                XMLUtils.writeAttribute(out, indentation, "remote-server-ref", Boolean.toString(this._remoteServerRef));
                XMLUtils.writeAttribute(out, indentation, "jndi-properties-file", this._jndiPropertiesFile);
            }
            XMLUtils.writeTagAttributeEnd(out, indentation, "ejb-ref-mapping");
            XMLUtils.writeTagEnd(out, indentation, "ejb-ref-mapping");
        }
    }

    private void init() {
        this.setXpath("ejb-ref-mapping");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(this.getNode(), "location")) != null && !val.trim().equals("")) {
                this._location = val;
            }
            if ((val = XMLUtils.getAttribute(this.getNode(), "remote-server-ref")) != null && val.trim().equalsIgnoreCase("true")) {
                this._remoteServerRef = true;
            }
            if ((val = XMLUtils.getAttribute(this.getNode(), "jndi-properties-file")) != null && !val.trim().equals("")) {
                this._jndiPropertiesFile = val;
            }
        } else if (this.getDDBean() != null && this.getDDBean().getText(this.beanKey()) != null) {
            this._name = this.getDDBean().getText(this.beanKey())[0];
        }
    }

    public ViewableJTree[] subTrees() {
        EjbRefMappingTreeNode treeNode = new EjbRefMappingTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }
}

