/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.GroupType;
import oracle.oc4j.admin.deploy.spi.xml.StringTypeBase;
import oracle.oc4j.admin.management.shared.Group;

public class GroupNameType
extends StringTypeBase {
    protected String _description = null;
    private Set _groups = null;

    public GroupNameType() {
        this((ConfigBeanNode)null);
    }

    public GroupNameType(ConfigBeanNode parent) {
        super(parent);
        this._validateToTags = false;
        this.setValue("");
    }

    public String[] getTags() {
        this._groups = this.determineRoot().getGroups();
        if (this._groups != null) {
            String[] newTags = new String[this._groups.size()];
            Iterator it = this._groups.iterator();
            for (int n = 0; n < this._groups.size(); ++n) {
                Group group = (Group)it.next();
                newTags[n] = group.getName();
            }
            super.setTags(newTags);
        }
        return super.getTags();
    }

    public void setValue(String value) {
        super.setValue(value);
        if (this._groups == null) {
            return;
        }
        Iterator it = this._groups.iterator();
        for (int n = 0; n < this._groups.size(); ++n) {
            Group group = (Group)it.next();
            if (!group.getName().equals(value)) continue;
            this._description = group.getDescription();
            if (this._description == null) {
                this._description = "";
            }
            ((GroupType)this.getConfigParent()).setName(this);
            break;
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this.getValue() == null || this.getValue().length() == 0) {
            return;
        }
        XMLUtils.writeAttribute(out, indentation, "name", this.getValue());
    }

    public String toString() {
        return this.getValue();
    }
}

