/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.GroupNameType;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceResourceType;

public class GroupType
extends ConfigBeanNode {
    protected GroupNameType _name = null;
    protected String _description = null;

    public GroupType(ConfigBeanNode parent) {
        super(null, parent);
        if (parent instanceof NamespaceResourceType) {
            this.setXpath("security-role-mapping/group");
        } else {
            this.setXpath("group");
        }
    }

    public GroupNameType getName() {
        return this._name;
    }

    public void setName(GroupNameType name) {
        GroupNameType oldValue = this._name;
        this._name = name;
        String oldDesc = this._description;
        this._description = name == null ? null : name.getDescription();
        if (this._description == null) {
            this._description = "";
        }
        this.firePropertyChange("name", oldValue, this._name);
        this.firePropertyChange("description", oldDesc, this._description);
    }

    public GroupNameType defaultName() {
        return new GroupNameType(this);
    }

    public String getDescription() {
        return this._description;
    }

    public String defaultDescription() {
        return "";
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("name") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._name == null || this._name.getValue() == null || this._name.getValue().length() == 0) {
            return;
        }
        XMLUtils.writeTagAttributeStart(out, indentation, "group");
        XMLUtils.writeAttribute(out, indentation, "name", this._name.getValue());
        XMLUtils.writeTagAttributeEnd(out, indentation, "group");
        XMLUtils.writeTagEnd(out, indentation, "group");
    }

    public static void writeXML(PrintWriter out, String indentation, GroupType[] groups) throws ExtendedRuntimeException {
        if (groups == null) {
            return;
        }
        for (int n = 0; n < groups.length; ++n) {
            groups[n].writeXML(out, indentation + "\t");
        }
    }

    public String toString() {
        if (this._name != null) {
            return this._name.getValue();
        }
        return "";
    }

    public String getPropertyDoc(String propertyName) {
        if (propertyName != null && propertyName.equals("description")) {
            return FormattingResourceBundle.DeploymentMessages.getString("groupDescription");
        }
        return super.getPropertyDoc(propertyName);
    }
}

