/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.GroupTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.GroupType;
import oracle.oc4j.admin.deploy.spi.xml.GroupsType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleMappingConfigBean;

public class GroupsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SecurityRoleMappingConfigBean _bean;
    private Method _method;
    private static final String ADD_GROUP_MENU_STRING = "Add Group";
    private JMenuItem _addGroupMenuItem;

    public GroupsTreeNode(ConfigTreeNode rootNode, GroupsType groups) {
        super(groups);
        this.setRootNode(rootNode);
        this._bean = (SecurityRoleMappingConfigBean)groups.getConfigParent();
        this._addGroupMenuItem = new JMenuItem(ADD_GROUP_MENU_STRING);
        this._addGroupMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addGroupMenuItem.setFont(GroupsTreeNode.getFont());
        this._addGroupMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addGroupMenuItem);
    }

    public String viewHeaderString() {
        return "Groups";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        GroupType[] groups = this._bean.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                GroupType group = groups[i];
                if (group == null) continue;
                GroupTreeNode groupTreeNode = new GroupTreeNode(this.getRootNode(), group);
                this.addChild(groupTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            GroupType newGroup;
            if (event.getActionCommand().equals(ADD_GROUP_MENU_STRING) && this.showAddDialog(newGroup = new GroupType(this._bean), ADD_GROUP_MENU_STRING)) {
                this._bean.addGroup(newGroup);
                GroupTreeNode newNode = new GroupTreeNode(this, newGroup);
                this.insertNode(newNode);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof GroupTreeNode) {
            GroupType group = (GroupType)node.getConfigBeanNode();
            this._bean.removeGroup(group);
            this.removeNode(node);
        }
    }
}

