/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportOrRemoveType;
import oracle.oc4j.admin.deploy.spi.xml.ImportTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportType;
import oracle.oc4j.admin.deploy.spi.xml.RemoveTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.RemoveType;

public class ImportOrRemoveTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ImportOrRemoveType _bean;
    private static final String ADD_IMPORT_MENU_STRING = "Add Import";
    private static final String ADD_REMOVE_MENU_STRING = "Add Remove";
    private static final String REMOVE_IMPORT_OR_REMOVE_MENU_STRING = "Remove Import/Remove";
    private JMenuItem _addImportMenuItem;
    private JMenuItem _addRemoveMenuItem;
    private JMenuItem _removeImportOrRemoveMenuItem;

    public ImportOrRemoveTreeNode(ConfigTreeNode rootNode, ImportOrRemoveType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addImportMenuItem = new JMenuItem(ADD_IMPORT_MENU_STRING);
        this._addImportMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addImportMenuItem.setFont(ImportOrRemoveTreeNode.getFont());
        this._addImportMenuItem.addActionListener(this);
        if (this._bean.getImport() != null) {
            this._addImportMenuItem.setEnabled(false);
        }
        this._addRemoveMenuItem = new JMenuItem(ADD_REMOVE_MENU_STRING);
        this._addRemoveMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRemoveMenuItem.setFont(ImportOrRemoveTreeNode.getFont());
        this._addRemoveMenuItem.addActionListener(this);
        if (this._bean.getRemove() != null) {
            this._addRemoveMenuItem.setEnabled(false);
        }
        this._removeImportOrRemoveMenuItem = new JMenuItem(REMOVE_IMPORT_OR_REMOVE_MENU_STRING);
        this._removeImportOrRemoveMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeImportOrRemoveMenuItem.setFont(ImportOrRemoveTreeNode.getFont());
        this._removeImportOrRemoveMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addImportMenuItem);
        this._popup.add(this._addRemoveMenuItem);
        this._popup.add(this._removeImportOrRemoveMenuItem);
    }

    public String viewHeaderString() {
        return "Import/Remove";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        RemoveType remove;
        ImportType imprt = this._bean.getImport();
        if (imprt != null) {
            ImportTreeNode importTreeNode = new ImportTreeNode(this.getRootNode(), imprt);
            this.addChild(importTreeNode);
            this._addImportMenuItem.setEnabled(false);
            this._addRemoveMenuItem.setEnabled(false);
        }
        if ((remove = this._bean.getRemove()) != null) {
            RemoveTreeNode removeTreeNode = new RemoveTreeNode(this.getRootNode(), remove);
            this.addChild(removeTreeNode);
            this._addImportMenuItem.setEnabled(false);
            this._addRemoveMenuItem.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_IMPORT_MENU_STRING)) {
                ImportType newImport = new ImportType(this._bean);
                if (this.showAddDialog(newImport, ADD_IMPORT_MENU_STRING)) {
                    this._bean.setImport(newImport);
                    ImportTreeNode newNode = new ImportTreeNode(this, newImport);
                    this.insertNode(newNode);
                    this._addImportMenuItem.setEnabled(false);
                    this._addRemoveMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_REMOVE_MENU_STRING)) {
                RemoveType newRemove = new RemoveType(this._bean);
                if (this.showAddDialog(newRemove, ADD_REMOVE_MENU_STRING)) {
                    this._bean.setRemove(newRemove);
                    RemoveTreeNode newNode = new RemoveTreeNode(this, newRemove);
                    this.insertNode(newNode);
                    this._addImportMenuItem.setEnabled(false);
                    this._addRemoveMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_IMPORT_OR_REMOVE_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ImportTreeNode) {
            this._bean.setImport(null);
            this.removeNode(node);
            this._addImportMenuItem.setEnabled(true);
            this._addRemoveMenuItem.setEnabled(true);
        } else if (node instanceof RemoveTreeNode) {
            this._bean.setRemove(null);
            this.removeNode(node);
            this._addImportMenuItem.setEnabled(true);
            this._addRemoveMenuItem.setEnabled(true);
        }
    }
}

