/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportOrRemoveTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportOrRemoveType;
import oracle.oc4j.admin.deploy.spi.xml.ImportedLibrariesType;

public class ImportedLibrariesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ImportedLibrariesType _bean;
    private static final String ADD_IMPORT_OR_REMOVE_MENU_STRING = "Add Import or Remove";
    private static final String REMOVE_IMPORTED_LIBRARIES_MENU_STRING = "Remove Imported Libraries";
    private JMenuItem _addImportOrRemoveMenuItem;
    private JMenuItem _removeImportedLibrariesMenuItem;

    public ImportedLibrariesTreeNode(ConfigTreeNode rootNode, ImportedLibrariesType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addImportOrRemoveMenuItem = new JMenuItem(ADD_IMPORT_OR_REMOVE_MENU_STRING);
        this._addImportOrRemoveMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addImportOrRemoveMenuItem.setFont(ImportedLibrariesTreeNode.getFont());
        this._addImportOrRemoveMenuItem.addActionListener(this);
        this._removeImportedLibrariesMenuItem = new JMenuItem(REMOVE_IMPORTED_LIBRARIES_MENU_STRING);
        this._removeImportedLibrariesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeImportedLibrariesMenuItem.setFont(ImportedLibrariesTreeNode.getFont());
        this._removeImportedLibrariesMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addImportOrRemoveMenuItem);
        this._popup.add(this._removeImportedLibrariesMenuItem);
    }

    public String viewHeaderString() {
        return "Imported Shared Libraries";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        ImportOrRemoveType[] libraries = this._bean.getLibraries();
        if (libraries != null) {
            for (int i = 0; i < libraries.length; ++i) {
                ImportOrRemoveType library = libraries[i];
                if (library == null) continue;
                ImportOrRemoveTreeNode importOrRemoveTreeNode = new ImportOrRemoveTreeNode(this.getRootNode(), library);
                this.addChild(importOrRemoveTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_IMPORT_OR_REMOVE_MENU_STRING)) {
                ImportOrRemoveType newImportOrRemove = new ImportOrRemoveType(this._bean);
                this._bean.addLibrary(newImportOrRemove);
                ImportOrRemoveTreeNode newNode = new ImportOrRemoveTreeNode(this, newImportOrRemove);
                this.insertNode(newNode);
            } else if (event.getActionCommand().equals(REMOVE_IMPORTED_LIBRARIES_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ImportOrRemoveTreeNode) {
            ImportOrRemoveType imp = (ImportOrRemoveType)node.getConfigBeanNode();
            this._bean.removeLibrary(imp);
            this.removeNode(node);
        }
    }
}

