/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.IpAccessTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.IpAccessType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class IpAccessesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_IP_ACCESS_MENU_STRING = "Add Ip Access";
    private JMenuItem _addIpAccessMenuItem;
    private IpAccessType[] ipAccessType = new IpAccessType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public IpAccessesTreeNode(ConfigTreeNode rootNode, MultipleType ipAccesses) {
        super(ipAccesses);
        this.setRootNode(rootNode);
        this._parentBean = ipAccesses.getConfigParent();
        this._addIpAccessMenuItem = new JMenuItem(ADD_IP_ACCESS_MENU_STRING);
        this._addIpAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addIpAccessMenuItem.setFont(IpAccessesTreeNode.getFont());
        this._addIpAccessMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addIpAccessMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getIpAccess", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addIpAccess", IpAccessType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeIpAccess", IpAccessType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Ip Accesses";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            IpAccessType[] ipAccesses = (IpAccessType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (ipAccesses != null) {
                for (int i = 0; i < ipAccesses.length; ++i) {
                    IpAccessType ipAccess = ipAccesses[i];
                    if (ipAccess == null) continue;
                    IpAccessTreeNode ipAccessTreeNode = new IpAccessTreeNode(this.getRootNode(), ipAccess);
                    this.addChild(ipAccessTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            IpAccessType newIpAccess;
            if (event.getActionCommand().equals(ADD_IP_ACCESS_MENU_STRING) && this.showAddDialog(newIpAccess = new IpAccessType(this._parentBean), ADD_IP_ACCESS_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newIpAccess);
                IpAccessTreeNode newNode = new IpAccessTreeNode(this, newIpAccess);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof IpAccessTreeNode) {
            try {
                IpAccessType ipAccess = (IpAccessType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, ipAccess);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

