/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JmxMBeanTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JmxMBeanType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class JmxMBeansTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_JMX_MBEAN_MENU_STRING = "Add JMX MBean";
    private JMenuItem _addJmxMBeanMenuItem;
    private JmxMBeanType[] jmxMBeansType = new JmxMBeanType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public JmxMBeansTreeNode(ConfigTreeNode rootNode, MultipleType jmxMBeans) {
        super(jmxMBeans);
        this.setRootNode(rootNode);
        this._parentBean = jmxMBeans.getConfigParent();
        this._addJmxMBeanMenuItem = new JMenuItem(ADD_JMX_MBEAN_MENU_STRING);
        this._addJmxMBeanMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJmxMBeanMenuItem.setFont(JmxMBeansTreeNode.getFont());
        this._addJmxMBeanMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addJmxMBeanMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getJmxMBeans", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addJmxMBean", JmxMBeanType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeJmxMBean", JmxMBeanType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "JMX MBeans";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            JmxMBeanType[] jmxMBeans = (JmxMBeanType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (jmxMBeans != null) {
                for (int i = 0; i < jmxMBeans.length; ++i) {
                    JmxMBeanType jmxMBean = jmxMBeans[i];
                    if (jmxMBean == null) continue;
                    JmxMBeanTreeNode jmxMBeanTreeNode = new JmxMBeanTreeNode(this.getRootNode(), jmxMBean);
                    this.addChild(jmxMBeanTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            JmxMBeanType newJmxMBean;
            if (event.getActionCommand().equals(ADD_JMX_MBEAN_MENU_STRING) && this.showAddDialog(newJmxMBean = new JmxMBeanType(this._parentBean, null), ADD_JMX_MBEAN_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newJmxMBean);
                JmxMBeanTreeNode newNode = new JmxMBeanTreeNode(this, newJmxMBean);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof JmxMBeanTreeNode) {
            try {
                JmxMBeanType jmxMBean = (JmxMBeanType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, jmxMBean);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

