/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingNamespaceTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingNamespaceType;
import oracle.oc4j.admin.deploy.spi.xml.LoggingNamespacesType;

public class LoggingNamespacesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private LoggingNamespacesType _bean;
    private static final String ADD_NAMESPACE_MENU_STRING = "Add Namespace";
    private static final String REMOVE_NAMESPACES_MENU_STRING = "Remove Namespaces";
    private JMenuItem _addNamespaceMenuItem;
    private JMenuItem _removeNamespacesMenuItem;

    public LoggingNamespacesTreeNode(ConfigTreeNode rootNode, LoggingNamespacesType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addNamespaceMenuItem = new JMenuItem(ADD_NAMESPACE_MENU_STRING);
        this._addNamespaceMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addNamespaceMenuItem.setFont(LoggingNamespacesTreeNode.getFont());
        this._addNamespaceMenuItem.addActionListener(this);
        this._removeNamespacesMenuItem = new JMenuItem(REMOVE_NAMESPACES_MENU_STRING);
        this._removeNamespacesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeNamespacesMenuItem.setFont(LoggingNamespacesTreeNode.getFont());
        this._removeNamespacesMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addNamespaceMenuItem);
        this._popup.add(this._removeNamespacesMenuItem);
    }

    public String viewHeaderString() {
        return "Namespaces";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        LoggingNamespaceType[] namespaces = this._bean.getNamespaces();
        if (namespaces != null) {
            for (int i = 0; i < namespaces.length; ++i) {
                LoggingNamespaceType namespace = namespaces[i];
                if (namespace == null) continue;
                LoggingNamespaceTreeNode LoggingNamespaceTreeNode2 = new LoggingNamespaceTreeNode(this.getRootNode(), namespace);
                this.addChild(LoggingNamespaceTreeNode2);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_NAMESPACE_MENU_STRING)) {
                LoggingNamespaceType newNamespace = new LoggingNamespaceType(this._bean, null);
                if (this.showAddDialog(newNamespace, ADD_NAMESPACE_MENU_STRING)) {
                    this._bean.addNamespace(newNamespace);
                    LoggingNamespaceTreeNode newNode = new LoggingNamespaceTreeNode(this, newNamespace);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_NAMESPACES_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof LoggingNamespaceTreeNode) {
            LoggingNamespaceType namespace = (LoggingNamespaceType)node.getConfigBeanNode();
            this._bean.removeNamespace(namespace);
            this.removeNode(node);
        }
    }
}

