/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingMessageTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingMessageType;
import oracle.oc4j.admin.deploy.spi.xml.LoggingOperationType;

public class LoggingOperationTreeNode
extends ConfigTreeNode
implements ActionListener {
    private LoggingOperationType _bean;
    private static final String REQUEST_TEXT = "Request";
    private static final String ADD_REQUEST_MENU_STRING = "Add Request";
    private static final String RESPONSE_TEXT = "Response";
    private static final String ADD_RESPONSE_MENU_STRING = "Add Response";
    private static final String FAULT_TEXT = "Fault";
    private static final String ADD_FAULT_MENU_STRING = "Add Fault";
    private static final String REMOVE_LOGGING_MENU_STRING = "Remove Logging";
    private JMenuItem _addRequestMenuItem;
    private JMenuItem _addResponseMenuItem;
    private JMenuItem _addFaultMenuItem;
    private JMenuItem _removeLoggingMenuItem;

    public LoggingOperationTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (LoggingOperationType)bean;
        this._addRequestMenuItem = new JMenuItem(ADD_REQUEST_MENU_STRING);
        this._addRequestMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRequestMenuItem.setFont(LoggingOperationTreeNode.getFont());
        this._addRequestMenuItem.addActionListener(this);
        if (this._bean.getRequest() != null) {
            this._addRequestMenuItem.setEnabled(false);
        }
        this._addResponseMenuItem = new JMenuItem(ADD_RESPONSE_MENU_STRING);
        this._addResponseMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addResponseMenuItem.setFont(LoggingOperationTreeNode.getFont());
        this._addResponseMenuItem.addActionListener(this);
        if (this._bean.getResponse() != null) {
            this._addResponseMenuItem.setEnabled(false);
        }
        this._addFaultMenuItem = new JMenuItem(ADD_FAULT_MENU_STRING);
        this._addFaultMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addFaultMenuItem.setFont(LoggingOperationTreeNode.getFont());
        this._addFaultMenuItem.addActionListener(this);
        if (this._bean.getFault() != null) {
            this._addFaultMenuItem.setEnabled(false);
        }
        this._removeLoggingMenuItem = new JMenuItem(REMOVE_LOGGING_MENU_STRING);
        this._removeLoggingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeLoggingMenuItem.setFont(LoggingOperationTreeNode.getFont());
        this._removeLoggingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRequestMenuItem);
        this._popup.add(this._addResponseMenuItem);
        this._popup.add(this._addFaultMenuItem);
        this._popup.add(this._removeLoggingMenuItem);
    }

    public String viewHeaderString() {
        return "Logging";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        LoggingMessageType fault;
        LoggingMessageType response;
        LoggingMessageType request = this._bean.getRequest();
        if (request != null) {
            LoggingMessageTreeNode requestTreeNode = new LoggingMessageTreeNode(this.getRootNode(), request, REQUEST_TEXT);
            this.addChild(requestTreeNode);
        }
        if ((response = this._bean.getResponse()) != null) {
            LoggingMessageTreeNode responseTreeNode = new LoggingMessageTreeNode(this.getRootNode(), response, RESPONSE_TEXT);
            this.addChild(responseTreeNode);
        }
        if ((fault = this._bean.getFault()) != null) {
            LoggingMessageTreeNode faultTreeNode = new LoggingMessageTreeNode(this.getRootNode(), fault, FAULT_TEXT);
            this.addChild(faultTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_REQUEST_MENU_STRING)) {
                LoggingMessageType newRequest;
                if (this._bean.getRequest() == null && this.showAddDialog(newRequest = this._bean.defaultRequest(), ADD_REQUEST_MENU_STRING)) {
                    this._bean.setRequest(newRequest);
                    LoggingMessageTreeNode newNode = new LoggingMessageTreeNode(this, newRequest, REQUEST_TEXT);
                    this.insertNode(newNode);
                    this._addRequestMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_RESPONSE_MENU_STRING)) {
                LoggingMessageType newResponse;
                if (this._bean.getResponse() == null && this.showAddDialog(newResponse = this._bean.defaultResponse(), ADD_RESPONSE_MENU_STRING)) {
                    this._bean.setResponse(newResponse);
                    LoggingMessageTreeNode newNode = new LoggingMessageTreeNode(this, newResponse, RESPONSE_TEXT);
                    this.insertNode(newNode);
                    this._addResponseMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_FAULT_MENU_STRING)) {
                LoggingMessageType newFault;
                if (this._bean.getFault() == null && this.showAddDialog(newFault = this._bean.defaultFault(), ADD_FAULT_MENU_STRING)) {
                    this._bean.setFault(newFault);
                    LoggingMessageTreeNode newNode = new LoggingMessageTreeNode(this, newFault, FAULT_TEXT);
                    this.insertNode(newNode);
                    this._addFaultMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_LOGGING_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof LoggingMessageTreeNode) {
            LoggingMessageTreeNode loggingMessageTreeNode = (LoggingMessageTreeNode)node;
            if (REQUEST_TEXT.equals(loggingMessageTreeNode.getDisplayText())) {
                this._bean.removeRequest();
                this.removeNode(node);
                this._addRequestMenuItem.setEnabled(true);
            } else if (RESPONSE_TEXT.equals(loggingMessageTreeNode.getDisplayText())) {
                this._bean.removeResponse();
                this.removeNode(node);
                this._addResponseMenuItem.setEnabled(true);
            } else if (FAULT_TEXT.equals(loggingMessageTreeNode.getDisplayText())) {
                this._bean.removeFault();
                this.removeNode(node);
                this._addFaultMenuItem.setEnabled(true);
            }
        }
    }
}

