/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceAccessType;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceResourceTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceResourceType;

public class NamespaceAccessTreeNode
extends ConfigTreeNode
implements ActionListener {
    private NamespaceAccessType _bean;
    private static final String ADD_READ_ACCESS_MENU_STRING = "Add Read Access";
    private static final String ADD_WRITE_ACCESS_MENU_STRING = "Add Write Access";
    private static final String REMOVE_NAMESPACE_ACCESS_MENU_STRING = "Remove Namespace Access";
    private JMenuItem _removeNamespaceAccessMenuItem;
    private JMenuItem _addReadAccessMenuItem;
    private JMenuItem _addWriteAccessMenuItem;

    public NamespaceAccessTreeNode(ConfigTreeNode rootNode, NamespaceAccessType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addReadAccessMenuItem = new JMenuItem(ADD_READ_ACCESS_MENU_STRING);
        this._addReadAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addReadAccessMenuItem.setFont(NamespaceAccessTreeNode.getFont());
        this._addReadAccessMenuItem.addActionListener(this);
        if (this._bean.getNamespaceReadAccess() != null) {
            this._addReadAccessMenuItem.setEnabled(false);
        }
        this._addWriteAccessMenuItem = new JMenuItem(ADD_WRITE_ACCESS_MENU_STRING);
        this._addWriteAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addWriteAccessMenuItem.setFont(NamespaceAccessTreeNode.getFont());
        this._addWriteAccessMenuItem.addActionListener(this);
        if (this._bean.getNamespaceWriteAccess() != null) {
            this._addWriteAccessMenuItem.setEnabled(false);
        }
        this._removeNamespaceAccessMenuItem = new JMenuItem(REMOVE_NAMESPACE_ACCESS_MENU_STRING);
        this._removeNamespaceAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeNamespaceAccessMenuItem.setFont(NamespaceAccessTreeNode.getFont());
        this._removeNamespaceAccessMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addReadAccessMenuItem);
        this._popup.add(this._addWriteAccessMenuItem);
        this._popup.add(this._removeNamespaceAccessMenuItem);
    }

    public String viewHeaderString() {
        return "Namespace Access";
    }

    public String toString() {
        return "Namespace Access";
    }

    protected void buildChildJTree() {
        NamespaceResourceType writeAccess;
        NamespaceResourceType readAccess = this._bean.getNamespaceReadAccess();
        if (readAccess != null) {
            NamespaceResourceTreeNode readAccessTreeNode = new NamespaceResourceTreeNode(this.getRootNode(), readAccess);
            this.addChild(readAccessTreeNode);
        }
        if ((writeAccess = this._bean.getNamespaceWriteAccess()) != null) {
            NamespaceResourceTreeNode writeAccessTreeNode = new NamespaceResourceTreeNode(this.getRootNode(), writeAccess);
            this.addChild(writeAccessTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_READ_ACCESS_MENU_STRING)) {
                if (this._bean.getNamespaceReadAccess() != null) {
                    return;
                }
                NamespaceResourceType newReadAccess = new NamespaceResourceType(this._bean, null, "Read");
                if (this.showAddDialog(newReadAccess, ADD_READ_ACCESS_MENU_STRING)) {
                    this._bean.setNamespaceReadAccess(newReadAccess);
                    NamespaceResourceTreeNode newNode = new NamespaceResourceTreeNode(this, newReadAccess);
                    this.insertNode(newNode);
                    this._addReadAccessMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_WRITE_ACCESS_MENU_STRING)) {
                if (this._bean.getNamespaceWriteAccess() != null) {
                    return;
                }
                NamespaceResourceType newWriteAccess = new NamespaceResourceType(this._bean, null, "Write");
                if (this.showAddDialog(newWriteAccess, ADD_WRITE_ACCESS_MENU_STRING)) {
                    this._bean.setNamespaceWriteAccess(newWriteAccess);
                    NamespaceResourceTreeNode newNode = new NamespaceResourceTreeNode(this, newWriteAccess);
                    this.insertNode(newNode);
                    this._addWriteAccessMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_NAMESPACE_ACCESS_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        NamespaceResourceType resource = (NamespaceResourceType)node.getConfigBeanNode();
        if (resource.equals(this._bean.getNamespaceReadAccess())) {
            this._bean.removeNamespaceReadAccess();
            this.removeNode(node);
            this._addReadAccessMenuItem.setEnabled(true);
        } else if (resource.equals(this._bean.getNamespaceWriteAccess())) {
            this._bean.removeNamespaceWriteAccess();
            this.removeNode(node);
            this._addWriteAccessMenuItem.setEnabled(true);
        }
    }
}

