/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleMappingConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceResourceType
extends SecurityRoleMappingConfigBean {
    static final String READ_ACCESS = "Read";
    static final String WRITE_ACCESS = "Write";
    String _root;
    String _accessType;

    public NamespaceResourceType(DDBean stdBean, ConfigBeanNode parent, Node node, String accessType) throws ConfigurationException {
        super(stdBean, parent, node, accessType);
        if (accessType == null || !accessType.equals(READ_ACCESS) && !accessType.equals(WRITE_ACCESS)) {
            throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("wrongArgumentType", new String[]{"<init>"}));
        }
        this._accessType = accessType;
        if (READ_ACCESS.equals(this._accessType)) {
            this.setXpath("read-access/namespace-resource");
        } else {
            this.setXpath("write-access/namespace-resource");
        }
    }

    public NamespaceResourceType(ConfigBeanNode parent, Node node, String accessType) throws ConfigurationException {
        this(null, parent, node, accessType);
    }

    public void setName(String name) throws ConfigurationException {
        String oldValue = this._name;
        this._name = name;
        this.firePropertyChange("name", oldValue, this._name);
    }

    public void setRoot(String root) throws ConfigurationException {
        String oldValue = this._root;
        this._root = root;
        this.firePropertyChange("root", oldValue, this._root);
    }

    public String getRoot() {
        return this._root;
    }

    public String defaultRoot() {
        if (this._root != null) {
            return this._root;
        }
        return "";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "namespace-resource");
        XMLUtils.writeAttributeForce(out, indentation, "root", this._root);
        XMLUtils.writeTagAttributeEnd(out, indentation, "namespace-resource");
        super.writeXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "namespace-resource");
    }

    protected void init(String accessType) throws ConfigurationException {
        if (READ_ACCESS.equals(accessType)) {
            this.setXpath("read-access/namespace-resource");
        } else {
            this.setXpath("write-access/namespace-resource");
        }
        this.init();
    }

    protected void init() throws ConfigurationException {
        boolean initSec = false;
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int ra = 0; ra < nodes.getLength(); ++ra) {
                node = nodes.item(ra);
                String name = node.getNodeName();
                if (!name.equals("namespace-resource")) continue;
                val = XMLUtils.getAttribute(node, "root");
                if (val != null && !val.trim().equals("")) {
                    this.setRoot(val);
                }
                NodeList namespaceResourceNodes = node.getChildNodes();
                for (int nr = 0; nr < namespaceResourceNodes.getLength(); ++nr) {
                    node = namespaceResourceNodes.item(nr);
                    name = node.getNodeName();
                    if (!name.equals("security-role-mapping")) continue;
                    this.setNode(node);
                    super.init();
                    initSec = true;
                }
            }
        }
        if (!initSec) {
            this.setNode(null);
            super.init();
        }
    }
}

