/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.IntegerType;
import oracle.oc4j.admin.deploy.spi.xml.NodeType;
import oracle.oc4j.admin.deploy.spi.xml.OpmnDiscoveryType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeerType
extends ConfigBeanNode {
    IntegerType _startPort = null;
    IntegerType _oldStartPort = null;
    IntegerType _range = null;
    IntegerType _oldRange = null;
    IntegerType _timeout = null;
    IntegerType _oldTimeout = null;
    String _bindAddr = null;
    NodeType[] _nodes = null;
    OpmnDiscoveryType _opmnDiscovery = null;

    public PeerType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public PeerType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setStartPort(IntegerType startPort) throws ConfigurationException {
        this._startPort = startPort;
        this.firePropertyChange("startPort", this._oldStartPort, this._startPort);
        if (this._startPort != null) {
            if (this._oldStartPort == null) {
                this._oldStartPort = this.defaultStartPort();
            }
            this._oldStartPort.setValue(this._startPort.getValue());
        } else {
            this._oldStartPort = null;
        }
    }

    public IntegerType getStartPort() {
        return this._startPort;
    }

    public IntegerType defaultStartPort() {
        try {
            return new IntegerType(this, "7800");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setRange(IntegerType range) throws ConfigurationException {
        this._range = range;
        this.firePropertyChange("range", this._oldRange, this._range);
        if (this._range != null) {
            if (this._oldRange == null) {
                this._oldRange = this.defaultRange();
            }
            this._oldRange.setValue(this._range.getValue());
        } else {
            this._oldRange = null;
        }
    }

    public IntegerType getRange() {
        return this._range;
    }

    public IntegerType defaultRange() {
        try {
            return new IntegerType(this, "5");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setTimeout(IntegerType timeout) throws ConfigurationException {
        this._timeout = timeout;
        this.firePropertyChange("timeout", this._oldTimeout, this._timeout);
        if (this._timeout != null) {
            if (this._oldTimeout == null) {
                this._oldTimeout = this.defaultTimeout();
            }
            this._oldTimeout.setValue(this._timeout.getValue());
        } else {
            this._oldTimeout = null;
        }
    }

    public IntegerType getTimeout() {
        return this._timeout;
    }

    public IntegerType defaultTimeout() {
        try {
            return new IntegerType(this, "3000");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setBindAddr(String bindAddr) throws ConfigurationException {
        String oldValue = this._bindAddr;
        this._bindAddr = bindAddr;
        this.firePropertyChange("bindAddr", oldValue, this._bindAddr);
    }

    public String getBindAddr() {
        return this._bindAddr;
    }

    public String defaultBindAddr() {
        return "";
    }

    public void setNodes(NodeType[] nodes) throws ConfigurationException {
        this._nodes = nodes;
    }

    public NodeType[] getNodes() {
        return this._nodes;
    }

    public NodeType[] defaultNodes() {
        return new NodeType[0];
    }

    public void addNodes() throws ConfigurationException {
        if (this._nodes != null) {
            return;
        }
        NodeType[] nodes = new NodeType[]{new NodeType(this, null)};
        this.setNodes(nodes);
    }

    public void removeNodes() throws ConfigurationException {
        if (this._nodes == null) {
            return;
        }
        this.setNodes(null);
    }

    public void addNode(NodeType node) throws ConfigurationException {
        node.setParent(this);
        int existingNodesCnt = 0;
        if (this._nodes != null) {
            existingNodesCnt = this._nodes.length;
        }
        NodeType[] newNodes = new NodeType[existingNodesCnt + 1];
        for (int n = 0; n < existingNodesCnt; ++n) {
            newNodes[n] = this._nodes[n];
        }
        newNodes[existingNodesCnt] = node;
        NodeType[] oldValue = this._nodes;
        this._nodes = newNodes;
        this.firePropertyChange("nodes", oldValue, this._nodes);
    }

    public void removeNode(NodeType node) throws ConfigurationException {
        int existingNodesCnt = 0;
        if (this._nodes != null) {
            existingNodesCnt = this._nodes.length;
        }
        NodeType[] newNodes = new NodeType[existingNodesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingNodesCnt; ++n) {
            if (node.equals(this._nodes[n])) continue;
            newNodes[newIndex++] = this._nodes[n];
        }
        NodeType[] oldValue = this._nodes;
        this._nodes = newNodes;
        this.firePropertyChange("nodes", oldValue, this._nodes);
    }

    public OpmnDiscoveryType getOpmnDiscovery() {
        return this._opmnDiscovery;
    }

    public void setOpmnDiscovery(OpmnDiscoveryType opmnDiscovery) throws ConfigurationException {
        OpmnDiscoveryType oldValue = this._opmnDiscovery;
        this._opmnDiscovery = opmnDiscovery;
        this.firePropertyChange("opmnDiscovery", oldValue, this._opmnDiscovery);
    }

    public void addOpmnDiscovery() throws ConfigurationException {
        if (this._opmnDiscovery != null) {
            return;
        }
        OpmnDiscoveryType opmnDiscovery = new OpmnDiscoveryType(this, null);
        this.setOpmnDiscovery(opmnDiscovery);
    }

    public void removeOpmnDiscovery() throws ConfigurationException {
        if (this._opmnDiscovery == null) {
            return;
        }
        this.setOpmnDiscovery(null);
    }

    public OpmnDiscoveryType defaultOpmnDiscovery() {
        try {
            return new OpmnDiscoveryType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "peer");
        XMLUtils.writeAttribute(out, indentation, "start-port", this._startPort);
        XMLUtils.writeAttribute(out, indentation, "range", this._range);
        if (this._bindAddr != null && this._bindAddr.length() > 0) {
            XMLUtils.writeAttribute(out, indentation + "\t", "bind_addr", this._bindAddr);
        }
        XMLUtils.writeAttribute(out, indentation, "timeout", this._timeout);
        XMLUtils.writeTagAttributeEnd(out, indentation, "peer");
        PeerType.writeXML(out, indentation + "\t", this._nodes);
        if (this.getOpmnDiscovery() != null) {
            this.getOpmnDiscovery().writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "peer");
    }

    private void init() throws ConfigurationException {
        this.setXpath("peer");
        Vector<NodeType> peerNodes = new Vector<NodeType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "start-port");
            if (val != null && !val.trim().equals("")) {
                IntegerType startPort = this.defaultStartPort();
                startPort.setValue(val);
                this.setStartPort(startPort);
            }
            if ((val = XMLUtils.getAttribute(node, "range")) != null && !val.trim().equals("")) {
                IntegerType range = this.defaultRange();
                range.setValue(val);
                this.setRange(range);
            }
            if ((val = XMLUtils.getAttribute(node, "timeout")) != null && !val.trim().equals("")) {
                IntegerType timeout = this.defaultTimeout();
                timeout.setValue(val);
                this.setTimeout(timeout);
            }
            if ((val = XMLUtils.getAttribute(node, "bind_addr")) != null && !val.trim().equals("")) {
                this._bindAddr = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("node")) {
                    NodeType configBean = new NodeType(this, node);
                    peerNodes.add(configBean);
                    continue;
                }
                if (!name.equals("opmn-discovery")) continue;
                OpmnDiscoveryType opmnDiscovery = new OpmnDiscoveryType(this, node);
                this.setOpmnDiscovery(opmnDiscovery);
            }
        }
        if (peerNodes.size() > 0) {
            this._nodes = peerNodes.toArray(new NodeType[0]);
        }
    }
}

