/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.CallPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationType;
import oracle.oc4j.admin.deploy.spi.xml.ClientPortRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StubPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.WsdlPortType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortInfoType
extends ConfigBeanNode {
    String _serviceEndpointInterface = null;
    CallPropertyType[] _callProperties = null;
    StubPropertyType[] _stubProperties = null;
    WsdlPortType _wsdlPort = null;
    ClientPortRuntimeType _runtime = null;
    ClientOperationType[] _clientOperations = null;

    public PortInfoType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public PortInfoType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setWsdlPort(WsdlPortType wsdlPort) {
        WsdlPortType oldValue = this._wsdlPort;
        this._wsdlPort = wsdlPort;
        this.firePropertyChange("wsdlPort", oldValue, this._wsdlPort);
    }

    public WsdlPortType defaultWsdlPort() {
        return new WsdlPortType(this);
    }

    public WsdlPortType getWsdlPort() {
        return this._wsdlPort;
    }

    public void addWsdlPort() {
        if (this._wsdlPort != null) {
            return;
        }
        WsdlPortType wsdlPort = new WsdlPortType(this);
        this.setWsdlPort(wsdlPort);
    }

    public void removeWsdlPort() {
        if (this._wsdlPort == null) {
            return;
        }
        this.setWsdlPort(null);
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        String oldValue = this._serviceEndpointInterface;
        this._serviceEndpointInterface = serviceEndpointInterface;
        this.firePropertyChange("serviceEndpointInterface", oldValue, this._serviceEndpointInterface);
    }

    public String defaultServiceEndpointInterface() {
        return "";
    }

    public String getServiceEndpointInterface() {
        return this._serviceEndpointInterface;
    }

    public void setCallProperties(CallPropertyType[] callProperties) {
        CallPropertyType[] oldValue = this._callProperties;
        this._callProperties = callProperties;
        this.firePropertyChange("callProperties", oldValue, this._callProperties);
    }

    public CallPropertyType[] getCallProperties() {
        return this._callProperties;
    }

    public CallPropertyType[] defaultCallProperties() {
        CallPropertyType[] ret = new CallPropertyType[]{new CallPropertyType(this)};
        return ret;
    }

    public void addCallProperties() {
        if (this._callProperties != null) {
            return;
        }
        CallPropertyType[] callProperties = new CallPropertyType[]{new CallPropertyType(this, null)};
        this.setCallProperties(callProperties);
    }

    public void removeCallProperties() {
        if (this._callProperties == null) {
            return;
        }
        this.setCallProperties(null);
    }

    public void addCallProperty(CallPropertyType callProperty) {
        callProperty.setParent(this);
        int existingCallPropertiesCnt = 0;
        if (this._callProperties != null) {
            existingCallPropertiesCnt = this._callProperties.length;
        }
        CallPropertyType[] newCallProperties = new CallPropertyType[existingCallPropertiesCnt + 1];
        for (int n = 0; n < existingCallPropertiesCnt; ++n) {
            newCallProperties[n] = this._callProperties[n];
        }
        newCallProperties[existingCallPropertiesCnt] = callProperty;
        CallPropertyType[] oldValue = this._callProperties;
        this._callProperties = newCallProperties;
        this.firePropertyChange("callProperties", oldValue, this._callProperties);
    }

    public void removeCallProperty(CallPropertyType callProperty) {
        int existingCallPropertiesCnt = 0;
        if (this._callProperties != null) {
            existingCallPropertiesCnt = this._callProperties.length;
        }
        CallPropertyType[] newCallProperties = new CallPropertyType[existingCallPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingCallPropertiesCnt; ++n) {
            if (callProperty.equals(this._callProperties[n])) continue;
            newCallProperties[newIndex++] = this._callProperties[n];
        }
        if (newCallProperties.length == 0) {
            newCallProperties = null;
        }
        CallPropertyType[] oldValue = this._callProperties;
        this._callProperties = newCallProperties;
        this.firePropertyChange("callProperties", oldValue, this._callProperties);
    }

    public void setStubProperties(StubPropertyType[] stubProperties) {
        StubPropertyType[] oldValue = this._stubProperties;
        this._stubProperties = stubProperties;
        this.firePropertyChange("stubProperties", oldValue, this._stubProperties);
    }

    public StubPropertyType[] getStubProperties() {
        return this._stubProperties;
    }

    public StubPropertyType[] defaultStubProperties() {
        StubPropertyType[] ret = new StubPropertyType[]{new StubPropertyType(this)};
        return ret;
    }

    public void addStubProperties() {
        if (this._stubProperties != null) {
            return;
        }
        StubPropertyType[] stubProperties = new StubPropertyType[]{new StubPropertyType(this, null)};
        this.setStubProperties(stubProperties);
    }

    public void removeStubProperties() {
        if (this._stubProperties == null) {
            return;
        }
        this.setStubProperties(null);
    }

    public void addStubProperty(StubPropertyType stubProperty) {
        stubProperty.setParent(this);
        int existingStubPropertiesCnt = 0;
        if (this._stubProperties != null) {
            existingStubPropertiesCnt = this._stubProperties.length;
        }
        StubPropertyType[] newStubProperties = new StubPropertyType[existingStubPropertiesCnt + 1];
        for (int n = 0; n < existingStubPropertiesCnt; ++n) {
            newStubProperties[n] = this._stubProperties[n];
        }
        newStubProperties[existingStubPropertiesCnt] = stubProperty;
        StubPropertyType[] oldValue = this._stubProperties;
        this._stubProperties = newStubProperties;
        this.firePropertyChange("stubProperties", oldValue, this._stubProperties);
    }

    public void removeStubProperty(StubPropertyType stubProperty) {
        int existingStubPropertiesCnt = 0;
        if (this._stubProperties != null) {
            existingStubPropertiesCnt = this._stubProperties.length;
        }
        StubPropertyType[] newStubProperties = new StubPropertyType[existingStubPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingStubPropertiesCnt; ++n) {
            if (stubProperty.equals(this._stubProperties[n])) continue;
            newStubProperties[newIndex++] = this._stubProperties[n];
        }
        if (newStubProperties.length == 0) {
            newStubProperties = null;
        }
        StubPropertyType[] oldValue = this._stubProperties;
        this._stubProperties = newStubProperties;
        this.firePropertyChange("stubProperties", oldValue, this._stubProperties);
    }

    public void setRuntime(ClientPortRuntimeType runtime) throws ConfigurationException {
        ClientPortRuntimeType oldValue = this._runtime;
        this._runtime = runtime;
        this.firePropertyChange("runtime", oldValue, this._runtime);
    }

    public ClientPortRuntimeType getRuntime() {
        return this._runtime;
    }

    public ClientPortRuntimeType defaultRuntime() throws ConfigurationException {
        try {
            return new ClientPortRuntimeType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addRuntime() throws ConfigurationException {
        if (this._runtime != null) {
            return;
        }
        ClientPortRuntimeType runtime = new ClientPortRuntimeType(this, null);
        this.setRuntime(runtime);
    }

    public void removeRuntime() throws ConfigurationException {
        if (this._runtime == null) {
            return;
        }
        this.setRuntime(null);
    }

    public void setClientOperations(ClientOperationType[] clientOperations) {
        this._clientOperations = clientOperations;
    }

    public ClientOperationType[] getClientOperations() {
        return this._clientOperations;
    }

    public ClientOperationType[] defaultClientOperations() {
        return new ClientOperationType[0];
    }

    public void addClientOperations() throws ConfigurationException {
        if (this._clientOperations != null) {
            return;
        }
        ClientOperationType[] clientOperations = new ClientOperationType[]{new ClientOperationType(this, null)};
        this.setClientOperations(clientOperations);
    }

    public void removeClientOperations() {
        if (this._clientOperations == null) {
            return;
        }
        this.setClientOperations(null);
    }

    public void addClientOperation(ClientOperationType clientOperation) {
        clientOperation.setParent(this);
        int existingClientOperationsCnt = 0;
        if (this._clientOperations != null) {
            existingClientOperationsCnt = this._clientOperations.length;
        }
        ClientOperationType[] newClientOperations = new ClientOperationType[existingClientOperationsCnt + 1];
        for (int n = 0; n < existingClientOperationsCnt; ++n) {
            newClientOperations[n] = this._clientOperations[n];
        }
        newClientOperations[existingClientOperationsCnt] = clientOperation;
        ClientOperationType[] oldValue = this._clientOperations;
        this._clientOperations = newClientOperations;
        this.firePropertyChange("clientOperations", oldValue, this._clientOperations);
    }

    public void removeClientOperation(ClientOperationType clientOperation) {
        int existingClientOperationsCnt = 0;
        if (this._clientOperations != null) {
            existingClientOperationsCnt = this._clientOperations.length;
        }
        ClientOperationType[] newClientOperations = new ClientOperationType[existingClientOperationsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingClientOperationsCnt; ++n) {
            if (clientOperation.equals(this._clientOperations[n])) continue;
            newClientOperations[newIndex++] = this._clientOperations[n];
        }
        if (newClientOperations.length == 0) {
            newClientOperations = null;
        }
        ClientOperationType[] oldValue = this._clientOperations;
        this._clientOperations = newClientOperations;
        this.firePropertyChange("clientOperations", oldValue, this._clientOperations);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "port-info");
        XMLUtils.writeTagAttributeEnd(out, indentation, "port-info");
        if (this._wsdlPort != null) {
            this._wsdlPort.writeXML(out, indentation + "\t");
        }
        if (this._serviceEndpointInterface != null && this._serviceEndpointInterface.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "service-endpoint-interface", this._serviceEndpointInterface);
        }
        StubPropertyType.writeXML(out, indentation, this._stubProperties);
        CallPropertyType.writeXML(out, indentation, this._callProperties);
        if (this._runtime != null) {
            this._runtime.writeXML(out, indentation + "\t");
        }
        this.writeClientOperationsXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "port-info");
    }

    public static void writeXML(PrintWriter out, String indentation, PortInfoType[] ports) throws ExtendedRuntimeException {
        if (ports == null) {
            return;
        }
        for (int n = 0; n < ports.length; ++n) {
            ports[n].writeXML(out, indentation + "\t");
        }
    }

    public void writeCallPropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        CallPropertyType.writeXML(out, indentation, this._callProperties);
    }

    public void writeStubPropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        StubPropertyType.writeXML(out, indentation, this._stubProperties);
    }

    public void writeClientOperationsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ClientOperationType.writeXML(out, indentation, this._clientOperations);
    }

    private void init() throws ConfigurationException {
        this.setXpath("port-info");
        Vector<CallPropertyType> callProperties = new Vector<CallPropertyType>();
        Vector<StubPropertyType> stubProperties = new Vector<StubPropertyType>();
        Vector wsdlPort = new Vector(1);
        Vector<ClientOperationType> clientOperations = new Vector<ClientOperationType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("service-endpoint-interface")) {
                    this._serviceEndpointInterface = XMLUtils.getValue(node);
                    continue;
                }
                if (name.equals("call-property")) {
                    CallPropertyType callProperty = new CallPropertyType(this, node);
                    callProperties.add(callProperty);
                    continue;
                }
                if (name.equals("stub-property")) {
                    StubPropertyType stubProperty = new StubPropertyType(this, node);
                    stubProperties.add(stubProperty);
                    continue;
                }
                if (name.equals("wsdl-port")) {
                    this._wsdlPort = new WsdlPortType(this, node);
                    continue;
                }
                if (name.equals("runtime")) {
                    ClientPortRuntimeType runtime = new ClientPortRuntimeType(this, node);
                    this.setRuntime(runtime);
                    continue;
                }
                if (!name.equals("operations")) continue;
                NodeList operationNodes = node.getChildNodes();
                for (int op = 0; op < operationNodes.getLength(); ++op) {
                    node = operationNodes.item(op);
                    name = node.getNodeName();
                    if (!name.equals("operation")) continue;
                    ClientOperationType configBean = new ClientOperationType(this, node);
                    clientOperations.add(configBean);
                }
            }
        }
        if (callProperties.size() > 0) {
            this.setCallProperties(callProperties.toArray(new CallPropertyType[0]));
        }
        if (stubProperties.size() > 0) {
            this.setStubProperties(stubProperties.toArray(new StubPropertyType[0]));
        }
        if (clientOperations.size() > 0) {
            this._clientOperations = clientOperations.toArray(new ClientOperationType[0]);
        }
    }
}

