/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.PortInfoTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PortInfoType;

public class PortInfosTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_PORT_INFO_MENU_STRING = "Add Port Info";
    private JMenuItem _addPortInfoMenuItem;
    private PortInfoType[] PortInfoType = new PortInfoType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public PortInfosTreeNode(ConfigTreeNode rootNode, MultipleType portInfos) {
        super(portInfos);
        this.setRootNode(rootNode);
        this._parentBean = portInfos.getConfigParent();
        this._addPortInfoMenuItem = new JMenuItem(ADD_PORT_INFO_MENU_STRING);
        this._addPortInfoMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPortInfoMenuItem.setFont(PortInfosTreeNode.getFont());
        this._addPortInfoMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPortInfoMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getPortInfo", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addPortInfo", PortInfoType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removePortInfo", PortInfoType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Port Infos";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            PortInfoType[] portInfos = (PortInfoType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (portInfos != null) {
                for (int i = 0; i < portInfos.length; ++i) {
                    PortInfoType PortInfo = portInfos[i];
                    if (PortInfo == null) continue;
                    PortInfoTreeNode PortInfoTreeNode2 = new PortInfoTreeNode(this.getRootNode(), PortInfo);
                    this.addChild(PortInfoTreeNode2);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            PortInfoType newPortInfo;
            if (event.getActionCommand().equals(ADD_PORT_INFO_MENU_STRING) && this.showAddDialog(newPortInfo = new PortInfoType(this._parentBean), ADD_PORT_INFO_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newPortInfo);
                PortInfoTreeNode newNode = new PortInfoTreeNode(this, newPortInfo);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PortInfoTreeNode) {
            try {
                PortInfoType PortInfo = (PortInfoType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, PortInfo);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

