/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DefaultMappingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DefaultMappingType;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingEntriesType;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingEntryTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingEntryType;

public class PrincipalMappingEntriesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PrincipalMappingEntriesType _parentBean;
    private static final String ADD_PRINCIPAL_MAPPING_ENTRY_MENU_STRING = "Add Principal Mapping Entry";
    private static final String ADD_DEFAULT_MAPPING_MENU_STRING = "Add Default mapping";
    private static final String REMOVE_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING = "Remove Principal Mapping Entries";
    private JMenuItem _addPrincipalMappingEntryMenuItem;
    private JMenuItem _addDefaultMappingMenuItem;
    private JMenuItem _removePrincipalMappingEntriesMenuItem;
    private PrincipalMappingEntryType[] principalMappingEntriesType = new PrincipalMappingEntryType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public PrincipalMappingEntriesTreeNode(ConfigTreeNode rootNode, PrincipalMappingEntriesType principalMappingEntries) {
        super(principalMappingEntries);
        this.setRootNode(rootNode);
        this._parentBean = principalMappingEntries;
        this._addPrincipalMappingEntryMenuItem = new JMenuItem(ADD_PRINCIPAL_MAPPING_ENTRY_MENU_STRING);
        this._addPrincipalMappingEntryMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPrincipalMappingEntryMenuItem.setFont(PrincipalMappingEntriesTreeNode.getFont());
        this._addPrincipalMappingEntryMenuItem.addActionListener(this);
        this._addDefaultMappingMenuItem = new JMenuItem(ADD_DEFAULT_MAPPING_MENU_STRING);
        this._addDefaultMappingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addDefaultMappingMenuItem.setFont(PrincipalMappingEntriesTreeNode.getFont());
        this._addDefaultMappingMenuItem.addActionListener(this);
        if (this._parentBean.getDefaultMapping() != null) {
            this._addDefaultMappingMenuItem.setEnabled(false);
        }
        this._removePrincipalMappingEntriesMenuItem = new JMenuItem(REMOVE_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING);
        this._removePrincipalMappingEntriesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removePrincipalMappingEntriesMenuItem.setFont(PrincipalMappingEntriesTreeNode.getFont());
        this._removePrincipalMappingEntriesMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPrincipalMappingEntryMenuItem);
        this._popup.add(this._addDefaultMappingMenuItem);
        this._popup.add(this._removePrincipalMappingEntriesMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getPrincipalMappingEntries", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addPrincipalMappingEntry", PrincipalMappingEntryType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removePrincipalMappingEntry", PrincipalMappingEntryType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Principal Mapping Entries";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        DefaultMappingType defaultMapping = this._parentBean.getDefaultMapping();
        if (defaultMapping != null) {
            DefaultMappingTreeNode defaultMappingTreeNode = new DefaultMappingTreeNode(this.getRootNode(), defaultMapping);
            this.addChild(defaultMappingTreeNode);
        }
        try {
            PrincipalMappingEntryType[] principalMappingEntries = (PrincipalMappingEntryType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (principalMappingEntries != null) {
                for (int i = 0; i < principalMappingEntries.length; ++i) {
                    PrincipalMappingEntryType principalMappingEntry = principalMappingEntries[i];
                    if (principalMappingEntry == null) continue;
                    PrincipalMappingEntryTreeNode principalMappingEntryTreeNode = new PrincipalMappingEntryTreeNode(this.getRootNode(), principalMappingEntry);
                    this.addChild(principalMappingEntryTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_PRINCIPAL_MAPPING_ENTRY_MENU_STRING)) {
                PrincipalMappingEntryType newPrincipalMappingEntry = new PrincipalMappingEntryType(this._parentBean);
                if (this.showAddDialog(newPrincipalMappingEntry, ADD_PRINCIPAL_MAPPING_ENTRY_MENU_STRING)) {
                    this._addMethod.invoke((Object)this._parentBean, newPrincipalMappingEntry);
                    PrincipalMappingEntryTreeNode newNode = new PrincipalMappingEntryTreeNode(this, newPrincipalMappingEntry);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(ADD_DEFAULT_MAPPING_MENU_STRING)) {
                DefaultMappingType newDefaultMapping;
                if (this._parentBean.getDefaultMapping() == null && this.showAddDialog(newDefaultMapping = this._parentBean.defaultDefaultMapping(), ADD_DEFAULT_MAPPING_MENU_STRING)) {
                    this._parentBean.setDefaultMapping(newDefaultMapping);
                    DefaultMappingTreeNode newNode = new DefaultMappingTreeNode(this, newDefaultMapping);
                    this.insertNode(newNode);
                    this._addDefaultMappingMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PrincipalMappingEntryTreeNode) {
            try {
                PrincipalMappingEntryType principalMappingEntry = (PrincipalMappingEntryType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, principalMappingEntry);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        } else if (node instanceof DefaultMappingTreeNode) {
            this._parentBean.removeDefaultMapping();
            this.removeNode(node);
            this._addDefaultMappingMenuItem.setEnabled(true);
        }
    }
}

