/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.DatabaseType;
import oracle.oc4j.admin.deploy.spi.xml.MulticastType;
import oracle.oc4j.admin.deploy.spi.xml.PeerType;
import oracle.oc4j.admin.deploy.spi.xml.TunnelType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProtocolType
extends ConfigBeanNode {
    protected BooleanType _encryption = null;
    protected BooleanType _oldEncryption = null;
    protected BooleanType _opmn = null;
    protected BooleanType _oldOpmn = null;
    protected MulticastType _multicast = null;
    protected PeerType _peer = null;
    protected TunnelType _tunnel = null;
    protected DatabaseType _database = null;

    public ProtocolType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public ProtocolType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setEncryption(BooleanType encryption) throws ConfigurationException {
        this._encryption = encryption;
        this.firePropertyChange("encryption", this._oldEncryption, this._encryption);
        if (this._encryption != null) {
            if (this._oldEncryption == null) {
                this._oldEncryption = this.defaultEncryption();
            }
            this._oldEncryption.setValue(this._encryption.getValue());
        } else {
            this._oldEncryption = null;
        }
    }

    public BooleanType getEncryption() {
        return this._encryption;
    }

    public BooleanType defaultEncryption() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setOpmn(BooleanType opmn) throws ConfigurationException {
        this._opmn = opmn;
        this.firePropertyChange("opmn", this._oldOpmn, this._opmn);
        if (this._opmn != null) {
            if (this._oldOpmn == null) {
                this._oldOpmn = this.defaultOpmn();
            }
            this._oldOpmn.setValue(this._opmn.getValue());
        } else {
            this._oldOpmn = null;
        }
    }

    public BooleanType getOpmn() {
        return this._opmn;
    }

    public BooleanType defaultOpmn() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public MulticastType getMulticast() {
        return this._multicast;
    }

    public void setMulticast(MulticastType multicast) throws ConfigurationException {
        MulticastType oldValue = this._multicast;
        this._multicast = multicast;
        this.firePropertyChange("multicast", oldValue, this._multicast);
    }

    public void addMulticast() throws ConfigurationException {
        if (this._multicast != null) {
            return;
        }
        MulticastType multicast = new MulticastType(this, null);
        this.setMulticast(multicast);
    }

    public void removeMulticast() throws ConfigurationException {
        if (this._multicast == null) {
            return;
        }
        this.setMulticast(null);
    }

    public MulticastType defaultMulticast() {
        try {
            return new MulticastType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public PeerType getPeer() {
        return this._peer;
    }

    public void setPeer(PeerType peer) throws ConfigurationException {
        PeerType oldValue = this._peer;
        this._peer = peer;
        this.firePropertyChange("peer", oldValue, this._peer);
    }

    public void addPeer() throws ConfigurationException {
        if (this._peer != null) {
            return;
        }
        PeerType peer = new PeerType(this, null);
        this.setPeer(peer);
    }

    public void removePeer() throws ConfigurationException {
        if (this._peer == null) {
            return;
        }
        this.setPeer(null);
    }

    public PeerType defaultPeer() {
        try {
            return new PeerType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public TunnelType getTunnel() {
        return this._tunnel;
    }

    public void setTunnel(TunnelType tunnel) throws ConfigurationException {
        TunnelType oldValue = this._tunnel;
        this._tunnel = tunnel;
        this.firePropertyChange("tunnel", oldValue, this._tunnel);
    }

    public void addTunnel() throws ConfigurationException {
        if (this._tunnel != null) {
            return;
        }
        TunnelType tunnel = new TunnelType(this, null);
        this.setTunnel(tunnel);
    }

    public void removeTunnel() throws ConfigurationException {
        if (this._tunnel == null) {
            return;
        }
        this.setTunnel(null);
    }

    public TunnelType defaultTunnel() {
        try {
            return new TunnelType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public DatabaseType getDatabase() {
        return this._database;
    }

    public void setDatabase(DatabaseType database) throws ConfigurationException {
        DatabaseType oldValue = this._database;
        this._database = database;
        this.firePropertyChange("database", oldValue, this._database);
    }

    public void addDatabase() throws ConfigurationException {
        if (this._database != null) {
            return;
        }
        DatabaseType database = new DatabaseType(this, null);
        this.setDatabase(database);
    }

    public void removeDatabase() throws ConfigurationException {
        if (this._database == null) {
            return;
        }
        this.setDatabase(null);
    }

    public DatabaseType defaultDatabase() {
        try {
            return new DatabaseType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "protocol");
        XMLUtils.writeTagAttributeEnd(out, indentation, "protocol");
        if (this.getMulticast() != null) {
            this.getMulticast().writeXML(out, indentation + "\t");
        }
        if (this.getPeer() != null) {
            this.getPeer().writeXML(out, indentation + "\t");
        }
        if (this.getTunnel() != null) {
            this.getTunnel().writeXML(out, indentation + "\t");
        }
        if (this.getDatabase() != null) {
            this.getDatabase().writeXML(out, indentation + "\t");
        }
        if (this._encryption != null && "true".equals(this._encryption.getValue())) {
            XMLUtils.writeTag(out, indentation + "\t", "encryption", "");
        }
        if (this._opmn != null && "true".equals(this._opmn.getValue())) {
            XMLUtils.writeTag(out, indentation + "\t", "opmn", "");
        }
        XMLUtils.writeTagEnd(out, indentation, "protocol");
    }

    private void init() throws ConfigurationException {
        this.setXpath("protocol");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("multicast")) {
                    MulticastType multicast = new MulticastType(this, node);
                    this.setMulticast(multicast);
                    continue;
                }
                if (name.equals("peer")) {
                    PeerType peer = new PeerType(this, node);
                    this.setPeer(peer);
                    continue;
                }
                if (name.equals("tunnel")) {
                    TunnelType tunnel = new TunnelType(this, node);
                    this.setTunnel(tunnel);
                    continue;
                }
                if (name.equals("database")) {
                    DatabaseType database = new DatabaseType(this, node);
                    this.setDatabase(database);
                    continue;
                }
                if (name.equals("encryption")) {
                    BooleanType encryption = this.defaultEncryption();
                    encryption.setValue("true");
                    this.setEncryption(encryption);
                    continue;
                }
                if (!name.equals("opmn")) continue;
                BooleanType opmn = this.defaultOpmn();
                opmn.setValue("true");
                this.setOpmn(opmn);
            }
        }
    }
}

