/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;

public class RequestEnvelopeLimitsType
extends ConfigBeanNode {
    String kilobytes;
    String nestLevel;

    public RequestEnvelopeLimitsType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    private void init() throws ExtendedRuntimeException {
        this.setXpath("request-envelope-limits");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "kilobytes");
            if (val != null && !val.trim().equals("")) {
                this.setKilobytes(val);
            }
            if ((val = XMLUtils.getAttribute(node, "nest-level")) != null && !val.trim().equals("")) {
                this.setNestLevel(val);
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "request-envelope-limits");
        XMLUtils.writeAttribute(out, indentation, "kilobytes", this.kilobytes);
        XMLUtils.writeAttribute(out, indentation, "nest-level", this.nestLevel);
        try {
            out.println("/>");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setKilobytes(String kb) throws ExtendedRuntimeException {
        String oldValue = this.kilobytes;
        this.kilobytes = kb;
        this.firePropertyChange("kilobytes", oldValue, this.kilobytes);
    }

    public String getKilobytes() {
        return this.kilobytes;
    }

    public String defaultKilobytes() {
        return "-1";
    }

    public void setNestLevel(String nl) throws ExtendedRuntimeException {
        String oldValue = this.nestLevel;
        this.nestLevel = nl;
        this.firePropertyChange("nest-level", oldValue, this.nestLevel);
    }

    public String getNestLevel() {
        return this.nestLevel;
    }

    public String defaultNestLevel() {
        return "-1";
    }
}

