/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.RequestTrackerTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.RequestTrackerType;

public class RequestTrackersTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_REQUEST_TRACKER_MENU_STRING = "Add Request Tracker";
    private JMenuItem _addRequestTrackerMenuItem;
    private RequestTrackerType[] requestTrackerType = new RequestTrackerType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public RequestTrackersTreeNode(ConfigTreeNode rootNode, MultipleType requestTrackers) {
        super(requestTrackers);
        this.setRootNode(rootNode);
        this._parentBean = requestTrackers.getConfigParent();
        this._addRequestTrackerMenuItem = new JMenuItem(ADD_REQUEST_TRACKER_MENU_STRING);
        this._addRequestTrackerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRequestTrackerMenuItem.setFont(RequestTrackersTreeNode.getFont());
        this._addRequestTrackerMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRequestTrackerMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getRequestTrackers", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addRequestTracker", RequestTrackerType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeRequestTracker", RequestTrackerType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Request Trackers";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            RequestTrackerType[] requestTrackers = (RequestTrackerType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (requestTrackers != null) {
                for (int i = 0; i < requestTrackers.length; ++i) {
                    RequestTrackerType requestTracker = requestTrackers[i];
                    if (requestTracker == null) continue;
                    RequestTrackerTreeNode requestTrackerTreeNode = new RequestTrackerTreeNode(this.getRootNode(), requestTracker);
                    this.addChild(requestTrackerTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            RequestTrackerType newRequestTracker;
            if (event.getActionCommand().equals(ADD_REQUEST_TRACKER_MENU_STRING) && this.showAddDialog(newRequestTracker = new RequestTrackerType(this._parentBean), ADD_REQUEST_TRACKER_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newRequestTracker);
                RequestTrackerTreeNode newNode = new RequestTrackerTreeNode(this, newRequestTracker);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof RequestTrackerTreeNode) {
            try {
                RequestTrackerType requestTracker = (RequestTrackerType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, requestTracker);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

